-- Shortcut
local iit = interactive_item

-- Add with 500 weight.
lootboxes.add_puzzle("lootboxes:puzzle_torus_image_3x3", {
	iit_weight = 500,
    name = "3x3 Torus Puzzle (Image)",
    image = "iit_assets_unknown.png",
    boxes = {
    	["lootboxes:loot_trash"] = {iit_weight = 50},
    	["lootboxes:loot_common"] = {iit_weight = 50},
        ["lootboxes:loot_uncommon"]= {iit_weight = 60},
        ["lootboxes:loot_rare"] = {iit_weight = 5},
        
        ["lootboxes:loot_swords"] = {iit_weight = 3},
        ["lootboxes:loot_axes"] = {iit_weight = 3},
        ["lootboxes:loot_picks"] = {iit_weight = 3},
        ["lootboxes:loot_shovels"] = {iit_weight = 3},
    }
})

-- Define Functions
local main_func = function(item, command, player, data)
	if not command then return end -- Ignore if no command
	    
    local box_data = data.positions --Instead of just writing -".position" in everything just set it as box_data in this case
    -- Game logic
	for x = 1, 3 do
	    if command["move_left_"..x] then
	        local c1 = box_data[2][x]
	        local c2 = box_data[3][x]
	        local c3 = box_data[1][x]
	        -- Save Changes
	        box_data[1][x] = c1
	        box_data[2][x] = c2
	        box_data[3][x] = c3
	    elseif command["move_right_"..x] then
	        local c1 = box_data[3][x]
	        local c2 = box_data[1][x]
	        local c3 = box_data[2][x]
	        -- Save Changes
	        box_data[1][x] = c1
	        box_data[2][x] = c2
	        box_data[3][x] = c3
	    end
	end
	for y = 1, 3 do
	    if command["move_up_"..y] then
        	local c1 = box_data[y][2]
	        local c2 = box_data[y][3]
	        local c3 = box_data[y][1]
	        -- Save Changes
	        box_data[y][1] = c1
	        box_data[y][2] = c2
	        box_data[y][3] = c3
	    elseif command["move_down_"..y] then
        	local c1 = box_data[y][3]
	        local c2 = box_data[y][1]
	        local c3 = box_data[y][2]
	        -- Save Changes
	        box_data[y][1] = c1
	        box_data[y][2] = c2
	        box_data[y][3] = c3
	    end
	end
		
    -- Confirmation logic
    -- In this case, this action doesn't need to be confirmed as completed.
    if command["action_confirm"] then
        local win = true
        for x = 1, 3 do
            for y = 1, 3 do
                local e_y = (y * 3)-3
                local e_x = x + e_y
		    	if box_data[x][y] ~= e_x then
		    	    win = false
            		minetest.chat_send_player(player:get_player_name(), "Access denied.")
		    	    break
		    	end
            end
            if not win then
                break
            end
        end
	
	    if win then
            iit.call(item, command, player, data, "win")
        end
    end
end

local start_func = function(item, _, player, data)
    local itemstack = item
    local box_data = data
		
	if box_data.started then return end
		
	-- Random box_data
	box_data.positions = {}
		
	local values = {
		[1] = 1,
		[2] = 2,
		[3] = 3,
		[4] = 4,
		[5] = 5,
		[6] = 6,
		[7] = 7,
		[8] = 8,
		[9] = 9
	}
		
	local solvable = false
    for x = 1, 3 do
	    box_data.positions[x] = {}
	    for y = 1, 3 do
	        local rand = math.random(1, #values)
	        box_data.positions[x][y] = values[rand]
	        table.remove(values, rand)
	    end
	end
    -- Raw
    local raw_pos = {
    	box_data.positions[1][1],
    	box_data.positions[2][1],
        box_data.positions[3][1],
        box_data.positions[1][2],
    	box_data.positions[2][2],
        box_data.positions[3][2],
        box_data.positions[1][3],
    	box_data.positions[2][3],
        box_data.positions[3][3]
    }
    -- Check if can be solved
    local inversions = 0
    for i = 1, #raw_pos do
        for j = i + 1, #raw_pos do
            if raw_pos[i] > raw_pos[j] then
                inversions = inversions + 1
            end
        end
    end
    -- It's solvable?
    if inversions % 2 == 0 then
        solvable = true
    end
    -- If not, call start again.
    if not solvable then
        iit.call(item, nil, player, data, "start")
    end
    
    local meta = item:get_meta()
    if meta:get_string("predefined_lootable") == "" then
        local acti = meta:get_string("action")
    
        local choosen = iit.choose(lootboxes.puzzles[acti].boxes)
        box_data.lootable = choosen
    
        meta:set_string("inventory_image", lootboxes.loots[choosen].image or "iit_assets_unknown.png")
    else
        box_data.lootable = meta:get_string("predefined_lootable")
    
        meta:set_string("inventory_image", lootboxes.loots[meta:get_string("predefined_lootable")].image or "iit_assets_unknown.png")
    end
    meta:set_string("description", lootboxes.loots[box_data.lootable].name .. " Lootbox (Locked)")
    
    box_data.started = true
	
	-- These have art
	box_data.art = math.random(1, #lootboxes.arts)
end

local win_func = function(item, command, player, data)
    -- Open up.
    minetest.chat_send_player(player:get_player_name(), "The lootbox unlocks!")
    
    -- Name change
    local meta = item:get_meta()
    local rname = "???"
    
    if lootboxes.loots[data.lootable] and lootboxes.loots[data.lootable].name then
        rname = lootboxes.loots[data.lootable].name
    end
    meta:set_string("description", rname .. " Lootbox (Opened)")
    
    -- The inventories are by default not in the item meta, make them appear
    iit.open_inventory(item, player, "reward", data)
	interactive_item.delete_inventories(player)
    
    local pis = {
		16, 15, 14, 13,
		12, 11, 10, 9,
		8, 7, 6, 5,
		4, 3, 2, 1
	}
	
	local its = lootboxes.random_loot(data.lootable, math.random(6, 13), data)
	
	for i in ipairs(its) do
	    local rindex = pis[math.random(1, #pis)]
	    table.remove(pis, rindex)
        iit.set_inventory_item("reward", rindex, ItemStack(its[i]), data)
    end
    
    data.page = "reward"
end

local sanity_func = function(item, player, data)
	if not data.art then failed = 1 end
	
	if failed == 1 then
	    return false
    end
	
	return true
end

-- Define Forms
local main_form = function(item, player, data)
    local itemstack = ItemStack(item)
	local box_data = data
	
    if not box_data then return end
	
    local form = "size[8,10]"
	    
    -- For now, only 3x3
    local arrow_size = "1,1"
    local tile_size = "1.3,1.3"
    -- Add Buttons
	for i = 1, 3 do
	    form = form .. "image_button[".. i * 1.05 ..",0;"..arrow_size..";iit_assets_up.png;move_up_"..i..";]"
	    form = form .. "image_button[0,"..i * 1.05 ..";"..arrow_size..";iit_assets_left.png;move_left_"..i..";]"
	    form = form .. "image_button[".. i * 1.05 ..",4.35;"..arrow_size..";iit_assets_down.png;move_down_"..i..";]"
	    form = form .. "image_button[4.25,"..i * 1.05 ..";"..arrow_size..";iit_assets_right.png;move_right_"..i..";]"
	end
	-- Border deco.
	-- N/A
	
    -- Add Tiles
    for x = 1, 3 do
    for y = 1, 3 do
        local value = box_data.positions[x][y]
        e_x = ((value-1) % 3)
        e_y = math.floor((value-1) / 3)

        form = form .. "image["..x ..","..y ..";"..tile_size..";"..lootboxes.arts[box_data.art].."^[sheet:3x3:"..e_x ..","..e_y ..";]"
    end
    end
    -- Render the correct image aside
    for y = 1, 3 do
    for x = 1, 3 do
        local value = x + ((y-1)*3)
        e_x = ((value-1) % 3)
        e_y = math.floor((value-1) / 3)

        form = form .. "image["..x..","..y+5 ..";"..tile_size..";"..lootboxes.arts[box_data.art].."^[sheet:3x3:"..e_x ..","..e_y ..";]"
    end
    end
     
    -- Add Confirm
    form = form .. "image_button[6,4;1,1;iit_assets_check.png;action_confirm;]"
	
    return form
end

local reward_form = function(item, player, data)
    local itemstack = item
    local box_data = data
	
    if not box_data then return end
	
    local form = "size[8,7]"
    
    iit.open_inventory(item, player, "reward", data)
	
	-- Item Inventory
	form = form .. "list[current_player;iit_inventory-reward;0,0;8,2;]"
	
	-- Player Inventory
	form = form .. "list[current_player;main;0,2.8;8,1;]"
	form = form .. "list[current_player;main;0,4.0;8,3;8]"
	
	return form
end

-- Assign
interactive_item.register_action("lootboxes:puzzle_torus_image_3x3", {
	-- Form
	forms = {
        main = main_form,
        reward = reward_form
	},
	-- Logic
	logics = {
		-- Basic
		main = main_func,
		start = start_func,
		sanity = sanity_func,
		-- Ours
		win = win_func
	},
	-- Inventories
	inventories = {
		reward = {
			size = 16,
			allow_put = function(_, player) minetest.chat_send_player(player:get_player_name(), "You can't put items inside lootboxes.") return 0 end,
		}
	},
	options = {
		storeable = false,
	}
})