local function get_lootable(group)
    if not lootboxes.loots[group] then return end
    if not lootboxes.loots[group].items then return end
    local num = 0
    -- Get the max chance
	for i in ipairs(lootboxes.loots[group].items) do
		num = num + lootboxes.loots[group].items[i][2]
	end
	--
	local random = math.random(1, num)
	--
	local min = 0
	local max = 0
	for i in ipairs(lootboxes.loots[group].items) do
	    local change = lootboxes.loots[group].items[i][2]
	    max = max + change
	    if max >= random and random >= min then
			data = lootboxes.loots[group].items[i][1]
			break
	    end
	    min = min + change
	end
	return data
end

function lootboxes.random_loot_item(group)
    local ldata = get_lootable(group)
    
    if not ldata then return end
    
    local itemstack = ItemStack(ldata.item)
    
    -- Count, a table has more specific randoms.
    local count = 0
    if type(ldata.count) == "table" then
        local cnum = 0
        for i in ipairs(ldata.count) do
            cnum = cnum + ldata.count[i][2]
        end
        --
        local cran = math.random(1, cnum)
        --
        local cmin = 0
        local cmax = 0
        --
        for i in ipairs(ldata.count) do
    	    local change = ldata.count[i][2]
	        cmax = cmax + change
    	    if cmax >= cran and cran >= cmin then
	    		count = ldata.count[i][1]
	    		break
    	    end
	        cmin = cmin + change
    	end
    elseif ldata.count then
        count = ldata.count
    end
    
    -- Rcount
    if ldata.rcount then
    	count = math.random(ldata.rcount[1], ldata.rcount[2])
    end
	
	itemstack:set_count(count)
	
	-- Wear
	if ldata.wear then
    	itemstack:set_wear(math.random(ldata.wear[1] * 65535, ldata.wear[2] * 65535))
    end
    
    return itemstack:to_string()
end

function lootboxes.random_loot(group, size, data)
    local list = {}
	for i = 1, size do
	    local item = lootboxes.random_loot_item(group)
	    table.insert(list, item)
	end
	return list
end