lootboxes = {}

lootboxes.loots = {}
lootboxes.puzzles = {}

local tf = "lootboxes_overlay_front.png"
local ts = "lootboxes_overlay_side.png"
local tt = "lootboxes_overlay_top.png"

local te = "lootboxes_overlay_effect.png"

-- Arts
lootboxes.arts = {
	"lootboxes_art_1.png",
	"lootboxes_art_2.png",
	"lootboxes_art_3.png",
	-- Trees
	"default_pine_tree_top.png",
	"default_tree_top.png",
	-- Other
	"bubble.png",
	"heart.png",
	"default_apple.png",
	"default_book.png",
	-- Blocks
	"default_chest_front.png",
	"default_furnace_front.png",
}

-- Quick functions
function lootboxes.generate_img(img, topper, fronter, sider)
    img = img or "blank.png"
    topper = topper or "blank.png"
    fronter = fronter or "blank.png"
    sider = sider or "blank.png"

    local top = img.."&"..topper.."&"..tt.."&"..te
    local front = img.."&"..fronter.."&"..tf.."&"..te
    local side = img.."&"..sider.."&"..ts.."&"..te
    
    local edit = "[combine:256x256:"..
        "0,64=([inventorycube{"..top.."{"..front.."{"..side.."^[resize\\:256x128)"
        
    return edit
end
function lootboxes.generate_eimg(img, topper, fronter, sider)
    img = img or "blank.png"
    topper = topper or "blank.png"
    fronter = fronter or "blank.png"
    sider = sider or "blank.png"

    local top = img.."&"..topper.."&"..tt.."&"..te
    local front = img.."&"..fronter.."&"..tt.."&"..te
    local side = img.."&"..sider.."&"..tt.."&"..te
    
    local edit = "[combine:256x256:"..
        "0,64=([inventorycube{"..top.."{"..front.."{"..side.."^[resize\\:256x128)"
        
    return edit
end

function lootboxes.add_puzzle(puzzle, def)
    def.iit_weight = def.iit_weight or 1
    
    lootboxes.puzzles[puzzle] = def
end

function lootboxes.register_loot_table(group, def)
    lootboxes.loots[group] = def
    lootboxes.loots[group].items = {}
end

function lootboxes.add_loot(loot, weight, group)
    table.insert(lootboxes.loots[group].items, {loot, weight})
end

-- Items
local modpath = minetest.get_modpath("lootboxes")

-- Lootboxes
dofile(modpath.."/lootboxes/lootboxes.lua")

---- Functions
dofile(modpath.."/functions/random_loot.lua")

---- Loot tables
-- Normal
dofile(modpath.."/loot/trash.lua")
dofile(modpath.."/loot/common.lua")
dofile(modpath.."/loot/uncommon.lua")
dofile(modpath.."/loot/rare.lua")
--dofile(modpath.."/loot/epic.lua")
--dofile(modpath.."/loot/legendary.lua")

-- Tools
dofile(modpath.."/loot/tools/axes.lua")
dofile(modpath.."/loot/tools/picks.lua")
dofile(modpath.."/loot/tools/swords.lua")
dofile(modpath.."/loot/tools/shovels.lua")

---- Puzzles

-- Torus
dofile(modpath.."/puzzles/8_tiles.lua")
dofile(modpath.."/puzzles/torus_image_3x3.lua")
dofile(modpath.."/puzzles/torus_number_3x3.lua")

-- Other Items
dofile(modpath.."/book_of_chances/chance_book.lua")

---- Mapgen

dofile(modpath.."/mapgen/dungeon_loot.lua")