--====
-- Func
--====

jukesounds = {}
njukesounds = {}
music_player = {}

music_player.register_sound = function(id, name, sound)
    -- Function
    jukesounds[id] = sound
    -- Name for wheel
    table.insert(njukesounds, {id, name})
end

music_player.split_string = function(s,c)
	local list = {}
	if s then
		if c and string.match(s, c) then
			for word in string.gmatch(s, '([^' .. c .. ']+)') do
			    table.insert(list, word)
			end
		else
			table.insert(list, s)
		end
	end
	return list
end

--====
-- Sound
--====

local music_path = minetest.get_modpath("music_player")

dofile(music_path.."/soundpacks/piano_notes.lua")

-- Sounds from mt_game
dofile(music_path.."/soundpacks/default_sounds.lua")

--====
-- Recipes
--====

local rw = "group:wood"
local rg = "default:glass"
local rm = "default:mese_crystal"

minetest.register_craft({
	output = "music_player:music_player",
	recipe = {
		{rm, rg, rm},
		{rw, "music_player:disc", rw},
		{rm, rw, rm}
	}
})

minetest.register_craft({
	output = "music_player:disc",
	recipe = {
		{"", rg, ""},
		{rg, rm, rg},
		{"", rg, ""}
	}
})

--====
-- GUI
--====

local esc = minetest.formspec_escape

local jukeform = "size[15,15]"..
	"textarea[0.5,1.5;14.5,3;set_1;" .. esc("Set 1") .. ";]" ..
	"textarea[0.5,4.5;14.5,3;set_2;" .. esc("Set 2") .. ";]" ..
	"textarea[0.5,7.5;14.5,3;set_3;" .. esc("Set 3") .. ";]" ..
	"textarea[0.5,10.5;14.5,3;set_4;" .. esc("Set 4") .. ";]" ..
	"button[0.5,12;5,4;disc;".. esc("Disc") .."]" ..
	"button[5.0,12;5,4;turn_on;".. esc("Off") .."]" ..
	"button[9.5,12;5,4;play_from;".. esc("From Box") .."]" ..
	"button[5.0,13;5,4;config;" .. esc("Config") .. "]" ..
	"button[0.5,13;5,4;guide;" .. esc("Guide") .. "]" ..
	"button_exit[9.5,13;5,4;save;" .. esc("Save") .. "]"
	
--====
-- ITEM
--====

minetest.register_craftitem("music_player:disc", {
	description = "Empty Disc",
	inventory_image = "music_player_disc.png",
	groups = {disc = 1},
})

minetest.register_tool("music_player:music_disc", {
	description = "Music Disc",
	inventory_image = "music_player_disc.png",
	groups = {disc = 1, music_disc = 1, not_in_creative_inventory = 1},
})

--====
--NODE
--====

minetest.register_node("music_player:music_player", {
	description = "Music Player",
	groups = {choppy = 2, oddly_breakable_by_hand = 1},
	drawtype = "nodebox",
	tiles = {
		"default_wood.png^music_player_disc.png^default_glass.png",
		"default_wood.png",
		"default_wood.png",
		"default_wood.png",
		"default_wood.png",
		"default_wood.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
		    {-0.45, -0.5, -0.45,  0.45, -0.3,  0.45},
		}
	},
	-- Mesecons support
	mesecons = {effector = {
		action_on = function(pos)
			local meta = minetest.get_meta(pos)
			meta:set_string("status", "on")
		end,
		action_off = function(pos)
			local meta = minetest.get_meta(pos)
			meta:set_string("status", "off")
		end
	}},
	--
	on_construct = function(pos)
	    local meta = minetest.get_meta(pos)
	    local inv = meta:get_inventory()
	
	    meta:set_string("status", "off")
	    meta:set_string("formspec", jukeform)
	
	    inv:set_size("disc", 1*1)
	end,
	after_place_node = function(pos, placer)
	    local meta = minetest.get_meta(pos)
	    meta:set_string("owner", placer:get_player_name() or "")
	end,
	can_dig = function(pos,player)
		local meta = minetest.get_meta(pos);
		local inv = meta:get_inventory()
	    return inv:is_empty("disc")
	end,
	on_receive_fields = function(pos, formname, fields, player)
	    local meta = minetest.get_meta(pos)
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
		-- Save Lyrics
		if fields.save then
		    if fields.set_1 and fields.set_2 and fields.set_3 and fields.set_4 then
		    meta:set_string("set_1", fields.set_1:sub(1, 2000) or "")
		    meta:set_string("set_2", fields.set_2:sub(1, 2000) or "")
		    meta:set_string("set_3", fields.set_3:sub(1, 2000) or "")
		    meta:set_string("set_4", fields.set_4:sub(1, 2000) or "")
		    end
			
			local ops = "On"
			if meta:get_string("status") ~= "on" then
			ops = "Off"
			end
			local pla = "From Disc"
			if meta:get_string("from") ~= "disc" then
			pla = "From Box"
			end
			
	        meta:set_string("formspec", "size[15,15]" ..
	            "textarea[0.5,1.5;14.5,3;set_1;" .. esc("Set 1") .. ";".. esc(meta:get_string("set_1")) .."]" ..
	            "textarea[0.5,4.5;14.5,3;set_2;" .. esc("Set 2") .. ";".. esc(meta:get_string("set_2")) .."]" ..
	            "textarea[0.5,7.5;14.5,3;set_3;" .. esc("Set 3") .. ";".. esc(meta:get_string("set_3")) .."]" ..
	            "textarea[0.5,10.5;14.5,3;set_4;" .. esc("Set 4") .. ";".. esc(meta:get_string("set_4")) .."]" ..
	            "button[0.5,12;5,4;disc;".. esc("Disc") .."]" ..
	            "button[5.0,12;5,4;turn_on;".. esc(ops) .."]" ..
	            "button[9.5,12;5,4;play_from;".. esc(pla) .."]" ..
	            "button[5.0,13;5,4;config;" .. esc("Config") .. "]" ..
	            "button[0.5,13;5,4;guide;" .. esc("Guide") .. "]" ..
	            "button_exit[9.5,13;5,4;save;" .. esc("Save") .. "]")
	    -- Go to guide
		elseif fields.guide then
		    -- Build Formspec
			local formpart = "label[0,0.5;Sounds]"
			
			formpart = formpart .. "tablecolumns[text;text]"
			formpart = formpart .. "table[0,1.0;8,7;jukeguide;"
			formpart = formpart .. "Code, Sound"
			
			for i in ipairs(njukesounds) do
			local id = njukesounds[i][1]
			local na = njukesounds[i][2]
			formpart = formpart .. "," .. id ..", "..na
			end
			
			formpart = formpart .. "]"
		    -- Give Formspec
		    meta:set_string("formspec", "size[8,9]" ..
				formpart..
	            "button[2.5,8.0;3,1;jukebox;" .. esc("Music Player") .. "]")
		elseif fields.jukebox then
		    local ops = "On"
			if meta:get_string("status") ~= "on" then
			ops = "Off"
			end
			local pla = "From Disc"
			if meta:get_string("from") ~= "disc" then
			pla = "From Box"
			end
		
		    meta:set_string("formspec", "size[15,15]"..
				"textarea[0.5,1.5;14.5,3;set_1;" .. esc("Set 1") .. ";".. esc(meta:get_string("set_1")) .."]" ..
	            "textarea[0.5,4.5;14.5,3;set_2;" .. esc("Set 2") .. ";".. esc(meta:get_string("set_2")) .."]" ..
	            "textarea[0.5,7.5;14.5,3;set_3;" .. esc("Set 3") .. ";".. esc(meta:get_string("set_3")) .."]" ..
	            "textarea[0.5,10.5;14.5,3;set_4;" .. esc("Set 4") .. ";".. esc(meta:get_string("set_4")) .."]" ..
	            "button[0.5,12;5,4;disc;".. esc("Disc") .."]" ..
	            "button[5.0,12;5,4;turn_on;".. esc(ops) .."]" ..
	            "button[9.5,12;5,4;play_from;".. esc(pla) .."]" ..
	            "button[5.0,13;5,4;config;" .. esc("Config") .. "]" ..
	            "button[0.5,13;5,4;guide;" .. esc("Guide") .. "]" ..
	            "button_exit[9.5,13;5,4;save;" .. esc("Save") .. "]")
	    elseif fields.turn_on or fields.play_from then
	
			if fields.turn_on then
	        if meta:get_string("status") == "on" then
	        meta:set_string("status", "off")
	        else
			meta:set_string("status", "on")
	        end
			elseif fields.play_from then
			if meta:get_string("from") == "disc" then
	        meta:set_string("from", "self")
	        else
			meta:set_string("from", "disc")
	        end
			end
	
	        local ops = "On"
	        local pla = "From Disc"
	        
			if fields.set_1 and fields.set_2 and fields.set_3 and fields.set_4 then
	        meta:set_string("set_1", fields.set_1:sub(1, 2000) or "")
		    meta:set_string("set_2", fields.set_2:sub(1, 2000) or "")
		    meta:set_string("set_3", fields.set_3:sub(1, 2000) or "")
		    meta:set_string("set_4", fields.set_4:sub(1, 2000) or "")
		    end
		
			if meta:get_string("status") ~= "on" then
			ops = "Off"
			end
			
			if meta:get_string("from") ~= "disc" then
			pla = "From Box"
			end
			
	        meta:set_string("formspec", "size[15,15]" ..
	            "textarea[0.5,1.5;14.5,3;set_1;" .. esc("Set 1") .. ";".. esc(meta:get_string("set_1")) .."]" ..
	            "textarea[0.5,4.5;14.5,3;set_2;" .. esc("Set 2") .. ";".. esc(meta:get_string("set_2")) .."]" ..
	            "textarea[0.5,7.5;14.5,3;set_3;" .. esc("Set 3") .. ";".. esc(meta:get_string("set_3")) .."]" ..
	            "textarea[0.5,10.5;14.5,3;set_4;" .. esc("Set 4") .. ";".. esc(meta:get_string("set_4")) .."]" ..
	            "button[0.5,12;5,4;disc;".. esc("Disc") .."]" ..
	            "button[5.0,12;5,4;turn_on;".. esc(ops) .."]" ..
	            "button[9.5,12;5,4;play_from;".. esc(pla) .."]" ..
	            "button[5.0,13;5,4;config;" .. esc("Config") .. "]" ..
	            "button[0.5,13;5,4;guide;" .. esc("Guide") .. "]" ..
	            "button_exit[9.5,13;5,4;save;" .. esc("Save") .. "]")
	    elseif fields.config then
	        local cf1 = minetest.deserialize(meta:get_string("set_1_mods")) or {g = 0, f = 0, p = 0}
	        local cf2 = minetest.deserialize(meta:get_string("set_2_mods")) or {g = 0, f = 0, p = 0}
			local cf3 = minetest.deserialize(meta:get_string("set_3_mods")) or {g = 0, f = 0, p = 0}
			local cf4 = minetest.deserialize(meta:get_string("set_4_mods")) or {g = 0, f = 0, p = 0}
	
	        meta:set_string("formspec", "size[8,9]" ..
				--
				"textarea[0.5,0.5;2.5,1;gain_1;" .. esc("Gain 1") .. ";".. esc(cf1.g) .."]" ..
				"textarea[3.0,0.5;2.5,1;fade_1;" .. esc("Fade 1") .. ";".. esc(cf1.f) .."]" ..
				"textarea[5.5,0.5;2.5,1;pitch_1;" .. esc("Pitch 1") .. ";".. esc(cf1.p) .."]" ..
				--
				"textarea[0.5,2;2.5,1;gain_2;" .. esc("Gain 2") .. ";".. esc(cf2.g) .."]" ..
				"textarea[3,2;2.5,1;fade_2;" .. esc("Fade 2") .. ";".. esc(cf2.f) .."]" ..
				"textarea[5.5,2;2.5,1;pitch_2;" .. esc("Pitch 2") .. ";".. esc(cf2.p) .."]" ..
				--
				"textarea[0.5,3.5;2.5,1;gain_3;" .. esc("Gain 3") .. ";".. esc(cf3.g) .."]" ..
				"textarea[3,3.5;2.5,1;fade_3;" .. esc("Fade 3") .. ";".. esc(cf3.f) .."]" ..
				"textarea[5.5,3.5;2.5,1;pitch_3;" .. esc("Pitch 3") .. ";".. esc(cf3.p) .."]" ..
				--
				"textarea[0.5,5;2.5,1;gain_4;" .. esc("Gain 4") .. ";".. esc(cf4.g) .."]" ..
				"textarea[3,5;2.5,1;fade_4;" .. esc("Fade 4") .. ";".. esc(cf4.f) .."]" ..
				"textarea[5.5,5;2.5,1;pitch_4;" .. esc("Pitch 4") .. ";".. esc(cf4.p) .."]" ..
				--
				"button[2.5,7.0;3,1;csave;" .. esc("Save") .. "]" ..
	            "button[2.5,8.0;3,1;jukebox;" .. esc("Music Player") .. "]")
	    elseif fields.disc then
			meta:set_string("formspec", "size[8,9]" ..
			    "textarea[3,0.5;2.5,1;name;" .. esc("Track Name") .. ";]" ..
				"list[current_name;disc;3.5,1.5;1,1;]" ..
				"button[4.5,3.0;3,1;decompile;" .. esc("Decompile") .. "]" ..
				"button[0.5,3.0;3,1;dsave;" .. esc("Save") .. "]" ..
	            "button[2.5,4.0;3,1;jukebox;" .. esc("Music Player") .. "]" ..
				"list[current_player;main;0,5;8,1;]" ..
				"list[current_player;main;0,6.25;8,3;8]")
		elseif fields.decompile then
			local inv = meta:get_inventory()
			local stack = inv:get_stack("disc", 1)
			if stack then
				local sdef = stack:get_definition()
				local cmeta = stack:get_meta()
				local smeta = cmeta
				
				if cmeta:get_string("owner") == "" or cmeta:get_string("owner") == name then
				if sdef and sdef.groups and sdef.groups.disc then
				
				meta:set_string("set_1", esc(smeta:get_string("set_1")))
                meta:set_string("set_2", esc(smeta:get_string("set_2")))
		        meta:set_string("set_3", esc(smeta:get_string("set_3")))
		        meta:set_string("set_4", esc(smeta:get_string("set_4")))
		
				meta:set_string("set_1_mods", smeta:get_string("set_1_mods"))
                meta:set_string("set_2_mods", smeta:get_string("set_2_mods"))
		        meta:set_string("set_3_mods", smeta:get_string("set_3_mods"))
		        meta:set_string("set_4_mods", smeta:get_string("set_4_mods"))
				end
				else
				minetest.chat_send_player(name, "You need to be the producer to decompile the disc!")
				end
			end
	    elseif fields.dsave then
	        local inv = meta:get_inventory()
			local stack = inv:get_stack("disc", 1)
			if stack then
				local sdef = stack:get_definition()
				local cmeta = stack:get_meta()
				
				if cmeta:get_string("owner") == "" or cmeta:get_string("owner") == name then
				if sdef and sdef.groups and sdef.groups.disc then
				-- Transform into a music disc
				local nstack = ItemStack(minetest.registered_items["music_player:music_disc"])
				local smeta = nstack:get_meta()
				
				smeta:set_string("set_1", meta:get_string("set_1"))
                smeta:set_string("set_2", meta:get_string("set_2"))
		        smeta:set_string("set_3", meta:get_string("set_3"))
		        smeta:set_string("set_4", meta:get_string("set_4"))
		
				smeta:set_string("set_1_mods", meta:get_string("set_1_mods"))
                smeta:set_string("set_2_mods", meta:get_string("set_2_mods"))
		        smeta:set_string("set_3_mods", meta:get_string("set_3_mods"))
		        smeta:set_string("set_4_mods", meta:get_string("set_4_mods"))
		
		        smeta:set_string("description", "\"" .. fields.name .. "\" By " .. meta:get_string("owner"))
		        smeta:set_string("owner", meta:get_string("owner"))
		
		        inv:set_stack("disc", 1, nstack)
				end
				else
				minetest.chat_send_player(name, "You need to be the producer to edit the disc!")
				end
			end
	    elseif fields.csave then
	
	    local verinum = function(num)
	        if not num then return nil end
	        if num >= 1.5 then
	        return 1.5
	        elseif -1.5 >= num then
	        return -1.5
	        end
	        return math.floor(num*100)/100
	    end
	
		local cf1 = {
			g = verinum(tonumber(fields.gain_1)) or 0,
			f = verinum(tonumber(fields.fade_1)) or 0,
			p = verinum(tonumber(fields.pitch_1)) or 0,
		}
		local cf2 = {
			g = verinum(tonumber(fields.gain_2)) or 0,
			f = verinum(tonumber(fields.fade_2)) or 0,
			p = verinum(tonumber(fields.pitch_2)) or 0,
		}
		local cf3 = {
			g = verinum(tonumber(fields.gain_3)) or 0,
			f = verinum(tonumber(fields.fade_3)) or 0,
			p = verinum(tonumber(fields.pitch_3)) or 0,
		}
		local cf4 = {
			g = verinum(tonumber(fields.gain_4)) or 0,
			f = verinum(tonumber(fields.fade_4)) or 0,
			p = verinum(tonumber(fields.pitch_4)) or 0,
		}
		
		meta:set_string("set_1_mods", minetest.serialize(cf1))
		meta:set_string("set_2_mods", minetest.serialize(cf2))
		meta:set_string("set_3_mods", minetest.serialize(cf3))
		meta:set_string("set_4_mods", minetest.serialize(cf4))
		
		meta:set_string("formspec", "size[8,9]" ..
				--
				"textarea[0.5,0.5;2.5,1;gain_1;" .. esc("Gain 1") .. ";".. esc(cf1.g) .."]" ..
				"textarea[3.0,0.5;2.5,1;fade_1;" .. esc("Fade 1") .. ";".. esc(cf1.f) .."]" ..
				"textarea[5.5,0.5;2.5,1;pitch_1;" .. esc("Pitch 1") .. ";".. esc(cf1.p) .."]" ..
				--
				"textarea[0.5,2;2.5,1;gain_2;" .. esc("Gain 2") .. ";".. esc(cf2.g) .."]" ..
				"textarea[3,2;2.5,1;fade_2;" .. esc("Fade 2") .. ";".. esc(cf2.f) .."]" ..
				"textarea[5.5,2;2.5,1;pitch_2;" .. esc("Pitch 2") .. ";".. esc(cf2.p) .."]" ..
				--
				"textarea[0.5,3.5;2.5,1;gain_3;" .. esc("Gain 3") .. ";".. esc(cf3.g) .."]" ..
				"textarea[3,3.5;2.5,1;fade_3;" .. esc("Fade 3") .. ";".. esc(cf3.f) .."]" ..
				"textarea[5.5,3.5;2.5,1;pitch_3;" .. esc("Pitch 3") .. ";".. esc(cf3.p) .."]" ..
				--
				"textarea[0.5,5;2.5,1;gain_4;" .. esc("Gain 4") .. ";".. esc(cf4.g) .."]" ..
				"textarea[3,5;2.5,1;fade_4;" .. esc("Fade 4") .. ";".. esc(cf4.f) .."]" ..
				"textarea[5.5,5;2.5,1;pitch_4;" .. esc("Pitch 4") .. ";".. esc(cf4.p) .."]" ..
				--
				"button[2.5,7.0;3,1;csave;" .. esc("Save") .. "]" ..
	            "button[2.5,8.0;3,1;jukebox;" .. esc("Music Player") .. "]")
		elseif fields.jukeguide then
		    local jukevent = minetest.explode_table_event(fields.jukeguide)
			if jukevent.type == "CHG" and jukevent.row > 0 then
			    local row = tonumber(jukevent.row)
				if row > 1 then -- ignore clicks on the header
					local noise = njukesounds[row - 1][2]
					minetest.sound_play(noise, {
                    pos = pos,
                    max_hear_distance = 25,
                    gain = 1,
                    fade = 1,
                    pitch = 1})
				end
			end
		end
		
	    end
	end
})

-- Function that plays jukeboxes
minetest.register_abm({
	label = "Play Music Players",
	nodenames = {"music_player:music_player"},
	interval = 1,
	chance = 1,
	catch_up = false,
	
	action = function(pos, node)
	    local nn = minetest.get_node(pos)
        local meta = minetest.get_meta(pos)
        local cs = meta:get_int("current")
        
        -- Only bother if it is playing
        if meta:get_string("status") == "on" then
        
        local set1 = music_player.split_string(meta:get_string("set_1"), " ") or {}
        local set2 = music_player.split_string(meta:get_string("set_2"), " ") or {}
        local set3 = music_player.split_string(meta:get_string("set_3"), " ") or {}
        local set4 = music_player.split_string(meta:get_string("set_4"), " ") or {}
        
        local set1m = minetest.deserialize(meta:get_string("set_1_mods")) or {g = 0, f = 0, p = 0}
        local set2m = minetest.deserialize(meta:get_string("set_2_mods")) or {g = 0, f = 0, p = 0}
        local set3m = minetest.deserialize(meta:get_string("set_3_mods")) or {g = 0, f = 0, p = 0}
        local set4m = minetest.deserialize(meta:get_string("set_4_mods")) or {g = 0, f = 0, p = 0}
        
        if meta:get_string("from") == "disc" then
        local inv = meta:get_inventory()
	    local stack = inv:get_stack("disc", 1)
	    if stack then
	    local sdef = stack:get_definition()
	    if sdef and sdef.groups and sdef.groups.disc then
	    local smeta = stack:get_meta()
        set1 = music_player.split_string(smeta:get_string("set_1"), " ") or {}
        set2 = music_player.split_string(smeta:get_string("set_2"), " ") or {}
        set3 = music_player.split_string(smeta:get_string("set_3"), " ") or {}
        set4 = music_player.split_string(smeta:get_string("set_4"), " ") or {}
        
        set1m = minetest.deserialize(smeta:get_string("set_1_mods")) or {g = 0, f = 0, p = 0}
        set2m = minetest.deserialize(smeta:get_string("set_2_mods")) or {g = 0, f = 0, p = 0}
        set3m = minetest.deserialize(smeta:get_string("set_3_mods")) or {g = 0, f = 0, p = 0}
        set4m = minetest.deserialize(smeta:get_string("set_4_mods")) or {g = 0, f = 0, p = 0}
        end
        end
        end
        
        if set1[cs] and jukesounds[set1[cs]] then
        local noise = jukesounds[set1[cs]]
        minetest.sound_play(noise.s, {
            pos = pos,
            max_hear_distance = 25,
            gain = (noise.g or 1)*(set1m.g + 1),
            fade = (noise.f or 1)*(set1m.f + 1),
            pitch = (noise.p or 1)*(set1m.p + 1),
        })
        end
        
        if set2[cs] and jukesounds[set2[cs]] then
        local noise = jukesounds[set2[cs]]
        minetest.after(0.33, function()
        minetest.sound_play(noise.s, {
            pos = pos,
            max_hear_distance = 25,
            gain = (noise.g or 1)*(set2m.g + 1),
            fade = (noise.f or 1)*(set2m.f + 1),
            pitch = (noise.p or 1)*(set2m.p + 1),
        })
        end)
        end
        
        if set3[cs] and jukesounds[set3[cs]] then
        local noise = jukesounds[set3[cs]]
        minetest.after(0.66, function()
        minetest.sound_play(noise.s, {
            pos = pos,
            max_hear_distance = 25,
            gain = (noise.g or 1)*(set3m.g + 1),
            fade = (noise.f or 1)*(set3m.f + 1),
            pitch = (noise.p or 1)*(set3m.p + 1),
        })
        end)
        end
        
        if set4[cs] and jukesounds[set4[cs]] then
        local noise = jukesounds[set4[cs]]
        minetest.after(1, function()
        minetest.sound_play(noise.s, {
            pos = pos,
            max_hear_distance = 25,
            gain = (noise.g or 1)*(set4m.g + 1),
            fade = (noise.f or 1)*(set4m.f + 1),
            pitch = (noise.p or 1)*(set4m.p + 1),
        })
        end)
        end
        
        local max = 0
        if #set1 > max then
        max = #set1
        end
        if #set2 > max then
        max = #set2
        end
        if #set3 > max then
        max = #set3
        end
        if #set4 > max then
        max = #set4
        end
        
        if cs >= max then
        meta:set_int("current", 0)
        else
        meta:set_int("current", cs + 1)
        end
        else
        meta:set_int("current", 0)
        end
    end
})