local S = morecurves.S

morecurves.register_all = function(mod_name, node_name, node_def)

    local function register_single(curve_name, collision_box, scale, mirrored, not_in_creative_inventory)
        local new_node_name = mod_name.. ":" .. "curve_" .. node_name .. "_" .. curve_name;
        local collisionbox = {
            type = "fixed",
            fixed = collision_box
        }

        local def = table.copy(node_def)

        if node_def.description ~= nil then
            def.description = S("@1 Curve " .. curve_name, node_def.description)
        else
            def.description = S("Curve " .. curve_name)
        end
        -- Use the primary tile for all sides of cut glasslike nodes and disregard paramtype2.
		if #def.tiles > 1 and def.drawtype and def.drawtype:find("glass") then
			def.tiles = {def.tiles[1]}
			def.paramtype2 = nil
		end
        -- Force backface culling, otherwise we'll get even more major z-fighting
        for i = 1, #def.tiles do
            local tile = def.tiles[i]
            if type(tile) == "string" then
                tile = { name = tile, backface_culling = true}
            elseif type(tile) == "table" then
                tile.backface_culling = true
            end
            def.tiles[i] = tile
        end
        if scale ~= nil then
            def.visual_scale = scale
        end

        if mirrored == true then
            def.on_rotate = function(pos, node, user, _, new_param2)
                if minetest.is_protected(pos, user:get_player_name()) then
                    minetest.record_protection_violation(pos, user:get_player_name())
                    return false
                end
                if math.floor(node.param2 / 4) == 5 and math.floor(new_param2 / 4) ~= 5 then -- switch to mirrored node
                    if node.name:sub(-1) == "r" then -- if is_mirrored
                        node.name = node.name:sub(1, -2)
                    else 
                        node.name = node.name .. "r"
                    end
                    node.param2 = new_param2
                else
                    node.param2 = new_param2
                end
                minetest.swap_node(pos, node)
                return true
            end
        end
        def.groups = def.groups or {}
        if not_in_creative_inventory == true then
            
            def.groups.not_in_creative_inventory = 1
            if new_node_name:sub(-1) == "r" then -- if is mirrored, then drop the normal on dig
                def.drop = new_node_name:sub(1, -2)
            end
        end
        def.drawtype = "mesh"
        def.mesh = curve_name ..".obj"
        def.collision_box = collisionbox
        def.selection_box = collisionbox
        def.is_ground_content = def.is_ground_content == true
        def.paramtype = "light"
        def.paramtype2 = def.paramtype2 or "facedir"
        if def.use_texture_alpha == nil then
            def.use_texture_alpha = node_def.use_texture_alpha
        end
        -- Darken light sources slightly to make up for their smaller visual size
        def.light_source = math.max(0, (def.light_source or 0) - 1)

        core.register_node(":" .. new_node_name, def)
    end

    register_single("45_1", {{-0.461, -0.5, 0.203,  0.5,-0.25, 0.5}, {-0.338, -0.5, -0.156, 0.604,-0.25, 0.203}, {-0.133, -0.5, -0.519, 0.528,-0.25, -0.156}, {0.02, -0.5, -0.71,  0.3,-0.25, -0.519}, {0.528, -0.5, -0.3,   0.72,-0.25, -0.02}}, 0.9995, true)
    register_single("45_1r",{{-0.5, -0.5, 0.203, 0.461,-0.25, 0.5},  {-0.604, -0.5, -0.156, 0.338,-0.25, 0.203}, {-0.528, -0.5, -0.519, 0.133,-0.25, -0.156}, {-0.3, -0.5, -0.71, 0.02,-0.25, -0.519}, {-0.72, -0.5, -0.3, -0.528,-0.25, -0.02}}, 0.9995, true, true)
    register_single("45_2", {{-0.461, -0.5, 0.203,  0.5, 0.00, 0.5}, {-0.338, -0.5, -0.156, 0.604, 0.00, 0.203}, {-0.133, -0.5, -0.519, 0.528, 0.00, -0.156}, {0.02, -0.5, -0.71,  0.3, 0.00, -0.519}, {0.528, -0.5, -0.3,   0.72, 0.00, -0.02}}, 0.9995, true)
    register_single("45_2r",{{-0.5, -0.5, 0.203, 0.461, 0.00, 0.5},  {-0.604, -0.5, -0.156, 0.338, 0.00, 0.203}, {-0.528, -0.5, -0.519, 0.133, 0.00, -0.156}, {-0.3, -0.5, -0.71, 0.02, 0.00, -0.519}, {-0.72, -0.5, -0.3, -0.528, 0.00, -0.02}}, 0.9995, true, true)
    register_single("45_3", {{-0.461, -0.5, 0.203,  0.5, 0.25, 0.5}, {-0.338, -0.5, -0.156, 0.604, 0.25, 0.203}, {-0.133, -0.5, -0.519, 0.528, 0.25, -0.156}, {0.02, -0.5, -0.71,  0.3, 0.25, -0.519}, {0.528, -0.5, -0.3,   0.72, 0.25, -0.02}}, 0.9995, true)
    register_single("45_3r",{{-0.5, -0.5, 0.203, 0.461, 0.25, 0.5},  {-0.604, -0.5, -0.156, 0.338, 0.25, 0.203}, {-0.528, -0.5, -0.519, 0.133, 0.25, -0.156}, {-0.3, -0.5, -0.71, 0.02, 0.25, -0.519}, {-0.72, -0.5, -0.3, -0.528, 0.25, -0.02}}, 0.9995, true, true)
    register_single("45",   {{-0.461, -0.5, 0.203,  0.5, 0.50, 0.5}, {-0.338, -0.5, -0.156, 0.604, 0.50, 0.203}, {-0.133, -0.5, -0.519, 0.528, 0.50, -0.156}, {0.02, -0.5, -0.71,  0.3, 0.50, -0.519}, {0.528, -0.5, -0.3,   0.72, 0.50, -0.02}}, 0.9995)
    
    register_single("90_1", {{-0.412, -0.5, 0.175, 0.5,-0.25, 0.5}, {-0.167, -0.5, -0.167, 0.5,-0.25, 0.175}, {0.175, -0.5, -0.412, 0.5,-0.25, -0.167}})
    register_single("90_2", {{-0.412, -0.5, 0.175, 0.5, 0.00, 0.5}, {-0.167, -0.5, -0.167, 0.5, 0.00, 0.175}, {0.175, -0.5, -0.412, 0.5, 0.00, -0.167}})
    register_single("90_3", {{-0.412, -0.5, 0.175, 0.5, 0.25, 0.5}, {-0.167, -0.5, -0.167, 0.5, 0.25, 0.175}, {0.175, -0.5, -0.412, 0.5, 0.25, -0.167}})
    register_single("90",   {{-0.412, -0.5, 0.175, 0.5, 0.50, 0.5}, {-0.167, -0.5, -0.167, 0.5, 0.50, 0.175}, {0.175, -0.5, -0.412, 0.5, 0.50, -0.167}})

    register_single("90_outer_1", {{-0.5, -0.5, -0.412, 0.35,-0.25, -0.5}, {-0.5, -0.5, -0.167, -0.167,-0.25, -0.412}, {-0.5, -0.5, 0.35, -0.412,-0.25, -0.167}})
    register_single("90_outer_2", {{-0.5, -0.5, -0.412, 0.35, 0.00, -0.5}, {-0.5, -0.5, -0.167, -0.167, 0.00, -0.412}, {-0.5, -0.5, 0.35, -0.412, 0.00, -0.167}})
    register_single("90_outer_3", {{-0.5, -0.5, -0.412, 0.35, 0.25, -0.5}, {-0.5, -0.5, -0.167, -0.167, 0.25, -0.412}, {-0.5, -0.5, 0.35, -0.412, 0.25, -0.167}})
    register_single("90_outer",   {{-0.5, -0.5, -0.412, 0.35, 0.50, -0.5}, {-0.5, -0.5, -0.167, -0.167, 0.50, -0.412}, {-0.5, -0.5, 0.35, -0.412, 0.50, -0.167}})

    register_single("90_outer_large_1", {{-0.5, -0.5, -0.5, 1.351,-0.25, -0.481}, {-0.5, -0.5, -0.481, 0.884,-0.25, -0.338}, {-0.5, -0.5, -0.338, 0.481,-0.25, -0.133}, {-0.5, -0.5, -0.133, 0.146,-0.25, 0.146}, {-0.5, -0.5, 0.146, -0.133,-0.25, 0.481}, {-0.5, -0.5, 0.481, -0.338,-0.25, 0.884}, {-0.5, -0.5, 0.884, -0.481,-0.25, 1.351}}, 0.999)
    register_single("90_outer_large_2", {{-0.5, -0.5, -0.5, 1.351, 0.00, -0.481}, {-0.5, -0.5, -0.481, 0.884, 0.00, -0.338}, {-0.5, -0.5, -0.338, 0.481, 0.00, -0.133}, {-0.5, -0.5, -0.133, 0.146, 0.00, 0.146}, {-0.5, -0.5, 0.146, -0.133, 0.00, 0.481}, {-0.5, -0.5, 0.481, -0.338, 0.00, 0.884}, {-0.5, -0.5, 0.884, -0.481, 0.00, 1.351}}, 0.999)
    register_single("90_outer_large_3", {{-0.5, -0.5, -0.5, 1.351, 0.25, -0.481}, {-0.5, -0.5, -0.481, 0.884, 0.25, -0.338}, {-0.5, -0.5, -0.338, 0.481, 0.25, -0.133}, {-0.5, -0.5, -0.133, 0.146, 0.25, 0.146}, {-0.5, -0.5, 0.146, -0.133, 0.25, 0.481}, {-0.5, -0.5, 0.481, -0.338, 0.25, 0.884}, {-0.5, -0.5, 0.884, -0.481, 0.25, 1.351}}, 0.999)
    register_single("90_outer_large",   {{-0.5, -0.5, -0.5, 1.351, 0.50, -0.481}, {-0.5, -0.5, -0.481, 0.884, 0.50, -0.338}, {-0.5, -0.5, -0.338, 0.481, 0.50, -0.133}, {-0.5, -0.5, -0.133, 0.146, 0.50, 0.146}, {-0.5, -0.5, 0.146, -0.133, 0.50, 0.481}, {-0.5, -0.5, 0.481, -0.338, 0.50, 0.884}, {-0.5, -0.5, 0.884, -0.481, 0.50, 1.351}}, 0.999)

    register_single("smooth_offset_1", {{0.481, -0.5, -1.351, 0.5,-0.25, 0.5},   {0.338, -0.5, -0.884, 0.481,-0.25, 0.5}, {0.133, -0.5, -0.481, 0.338,-0.25, 0.5}, {-0.147, -0.5, -0.147, 0.133,-0.25, 0.5}, {-0.285, -0.5, 0.01, -0.147,-0.25, 0.5}, {-0.448, -0.5, 0.267, -0.285,-0.25, 0.5}},  0.9985, true)
    register_single("smooth_offset_1r",{{-0.5, -0.5, -1.351, -0.481,-0.25, 0.5}, {-0.481, -0.5, -0.884, -0.338,-0.25, 0.5}, {-0.338, -0.5, -0.481,-0.133,-0.25, 0.5}, {-0.133, -0.5, -0.147, 0.147,-0.25, 0.5}, {0.147, -0.5, 0.01, 0.285,-0.25, 0.5}, {0.285, -0.5, 0.267, 0.448,-0.25, 0.5}},   0.9985, true, true)
    register_single("smooth_offset_2", {{0.481, -0.5, -1.351, 0.5, 0.00, 0.5},   {0.338, -0.5, -0.884, 0.481, 0.00, 0.5}, {0.133, -0.5, -0.481, 0.338, 0.00, 0.5}, {-0.147, -0.5, -0.147, 0.133, 0.00, 0.5}, {-0.285, -0.5, 0.01, -0.147, 0.00, 0.5}, {-0.448, -0.5, 0.267, -0.285, 0.00, 0.5}},  0.9985, true)
    register_single("smooth_offset_2r",{{-0.5, -0.5, -1.351, -0.481, 0.0, 0.5},  {-0.481, -0.5, -0.884, -0.338, 0.0, 0.5}, {-0.338, -0.5, -0.481,-0.133, 0.0, 0.5}, {-0.133, -0.5, -0.147, 0.147, 0.0, 0.5}, {0.147, -0.5, 0.01, 0.285, 0.0, 0.5}, {0.285, -0.5, 0.267, 0.448, 0.0, 0.5}},        0.9985, true, true)
    register_single("smooth_offset_3", {{0.481, -0.5, -1.351, 0.5, 0.25, 0.5},   {0.338, -0.5, -0.884, 0.481, 0.25, 0.5}, {0.133, -0.5, -0.481, 0.338, 0.25, 0.5}, {-0.147, -0.5, -0.147, 0.133, 0.25, 0.5}, {-0.285, -0.5, 0.01, -0.147, 0.25, 0.5}, {-0.448, -0.5, 0.267, -0.285, 0.25, 0.5}},  0.9985, true)
    register_single("smooth_offset_3r",{{-0.5, -0.5, -1.351, -0.481, 0.25, 0.5}, {-0.481, -0.5, -0.884, -0.338, 0.25, 0.5}, {-0.338, -0.5, -0.481,-0.133, 0.25, 0.5}, {-0.133, -0.5, -0.147, 0.147, 0.25, 0.5}, {0.147, -0.5, 0.01, 0.285, 0.25, 0.5}, {0.285, -0.5, 0.267, 0.448, 0.25, 0.5}},   0.9985, true, true)
    register_single("smooth_offset",   {{0.481, -0.5, -1.351, 0.5, 0.50, 0.5},   {0.338, -0.5, -0.884, 0.481, 0.50, 0.5}, {0.133, -0.5, -0.481, 0.338, 0.50, 0.5}, {-0.147, -0.5, -0.147, 0.133, 0.50, 0.5}, {-0.285, -0.5, 0.01, -0.147, 0.50, 0.5}, {-0.448, -0.5, 0.267, -0.285, 0.50, 0.5}},  0.9985)

    register_single("peak_45_1", {{-0.656, -0.5, -0.031, -0.443,-0.25, 0.335}, {-0.443, -0.5, -0.183, -0.222,-0.25, 0.556}, {-0.222, -0.5, -0.307, 0.222,-0.25, 0.778}, {0.222, -0.5, -0.183, 0.443,-0.25, 0.556}, {0.443, -0.5, -0.031, 0.656,-0.25, 0.335}}, 1.0005)
    register_single("peak_45_2", {{-0.656, -0.5, -0.031, -0.443, 0.00, 0.335}, {-0.443, -0.5, -0.183, -0.222, 0.00, 0.556}, {-0.222, -0.5, -0.307, 0.222, 0.00, 0.778}, {0.222, -0.5, -0.183, 0.443, 0.00, 0.556}, {0.443, -0.5, -0.031, 0.656, 0.00, 0.335}}, 1.0005)
    register_single("peak_45_3", {{-0.656, -0.5, -0.031, -0.443, 0.25, 0.335}, {-0.443, -0.5, -0.183, -0.222, 0.25, 0.556}, {-0.222, -0.5, -0.307, 0.222, 0.25, 0.778}, {0.222, -0.5, -0.183, 0.443, 0.25, 0.556}, {0.443, -0.5, -0.031, 0.656, 0.25, 0.335}}, 1.0005)
    register_single("peak_45",   {{-0.656, -0.5, -0.031, -0.443, 0.50, 0.335}, {-0.443, -0.5, -0.183, -0.222, 0.50, 0.556}, {-0.222, -0.5, -0.307, 0.222, 0.50, 0.778}, {0.222, -0.5, -0.183, 0.443, 0.50, 0.556}, {0.443, -0.5, -0.031, 0.656, 0.50, 0.335}}, 1.0005)

    register_single("inner_peak_45_1", {{-0.458, -0.5, -0.5, 0.458,-0.25, -0.313}, {-0.358, -0.5, -0.313, 0.358,-0.25, -0.1}, {-0.19, -0.5, -0.1, 0.19,-0.25, 0.102}})
    register_single("inner_peak_45_2", {{-0.458, -0.5, -0.5, 0.458, 0.00, -0.313}, {-0.358, -0.5, -0.313, 0.358, 0.00, -0.1}, {-0.19, -0.5, -0.1, 0.19, 0.00, 0.102}})
    register_single("inner_peak_45_3", {{-0.458, -0.5, -0.5, 0.458, 0.25, -0.313}, {-0.358, -0.5, -0.313, 0.358, 0.25, -0.1}, {-0.19, -0.5, -0.1, 0.19, 0.25, 0.102}})
    register_single("inner_peak_45",   {{-0.458, -0.5, -0.5, 0.458, 0.50, -0.313}, {-0.358, -0.5, -0.313, 0.358, 0.50, -0.1}, {-0.19, -0.5, -0.1, 0.19, 0.50, 0.102}})

    register_single("connector_end_1", {{-0.5, -0.5, -0.5, 0.5,-0.25, 0.5}, {-0.05, -0.5, -0.7, 0.35,-0.25, -0.5}, {0.5, -0.5, -0.35, 0.7,-0.25, 0.05}}, 1.001)
    register_single("connector_end_2", {{-0.5, -0.5, -0.5, 0.5, 0.00, 0.5}, {-0.05, -0.5, -0.7, 0.35, 0.00, -0.5}, {0.5, -0.5, -0.35, 0.7, 0.00, 0.05}}, 1.001)
    register_single("connector_end_3", {{-0.5, -0.5, -0.5, 0.5, 0.25, 0.5}, {-0.05, -0.5, -0.7, 0.35, 0.25, -0.5}, {0.5, -0.5, -0.35, 0.7, 0.25, 0.05}}, 1.001)
    register_single("connector_end",   {{-0.5, -0.5, -0.5, 0.5, 0.50, 0.5}, {-0.05, -0.5, -0.7, 0.35, 0.50, -0.5}, {0.5, -0.5, -0.35, 0.7, 0.50, 0.05}}, 1.001)

    register_single("connector_angle_1", {{-0.05, -0.5, -0.7, 0.35,-0.25, 0.45}, {-0.45, -0.5, -0.35, 0.7,-0.25, 0.05}, {-0.35, -0.5, -0.45, 0.05,-0.25, 0.7}, {-0.7, -0.5, -0.05, 0.45,-0.25, 0.35}, {-0.55, -0.5, -0.2, 0.2,-0.25, 0.55}, {-0.2, -0.5, -0.55, 0.55,-0.25, 0.2}}, 1.001)
    register_single("connector_angle_2", {{-0.05, -0.5, -0.7, 0.35, 0.00, 0.45}, {-0.45, -0.5, -0.35, 0.7, 0.00, 0.05}, {-0.35, -0.5, -0.45, 0.05, 0.00, 0.7}, {-0.7, -0.5, -0.05, 0.45, 0.00, 0.35}, {-0.55, -0.5, -0.2, 0.2, 0.00, 0.55}, {-0.2, -0.5, -0.55, 0.55, 0.00, 0.2}}, 1.001)
    register_single("connector_angle_3", {{-0.05, -0.5, -0.7, 0.35, 0.25, 0.45}, {-0.45, -0.5, -0.35, 0.7, 0.25, 0.05}, {-0.35, -0.5, -0.45, 0.05, 0.25, 0.7}, {-0.7, -0.5, -0.05, 0.45, 0.25, 0.35}, {-0.55, -0.5, -0.2, 0.2, 0.25, 0.55}, {-0.2, -0.5, -0.55, 0.55, 0.25, 0.2}}, 1.001)
    register_single("connector_angle",   {{-0.05, -0.5, -0.7, 0.35, 0.50, 0.45}, {-0.45, -0.5, -0.35, 0.7, 0.50, 0.05}, {-0.35, -0.5, -0.45, 0.05, 0.50, 0.7}, {-0.7, -0.5, -0.05, 0.45, 0.50, 0.35}, {-0.55, -0.5, -0.2, 0.2, 0.50, 0.55}, {-0.2, -0.5, -0.55, 0.55, 0.50, 0.2}}, 1.001)

    register_single("connector_all_1", {{-0.5, -0.5, -0.5, 0.5,-0.25, 0.5}, {-0.35, -0.5, -0.7, 0.35,-0.25, 0.7}, {-0.7, -0.5, -0.35, 0.7,-0.25, 0.35}}, 1.0015)
    register_single("connector_all_2", {{-0.5, -0.5, -0.5, 0.5, 0.00, 0.5}, {-0.35, -0.5, -0.7, 0.35, 0.00, 0.7}, {-0.7, -0.5, -0.35, 0.7, 0.00, 0.35}}, 1.0015)
    register_single("connector_all_3", {{-0.5, -0.5, -0.5, 0.5, 0.25, 0.5}, {-0.35, -0.5, -0.7, 0.35, 0.25, 0.7}, {-0.7, -0.5, -0.35, 0.7, 0.25, 0.35}}, 1.0015)
    register_single("connector_all",   {{-0.5, -0.5, -0.5, 0.5, 0.50, 0.5}, {-0.35, -0.5, -0.7, 0.35, 0.50, 0.7}, {-0.7, -0.5, -0.35, 0.7, 0.50, 0.35}}, 1.0015)
end