-- japaNESE names
jnese = {
	players = {},
}
-- made for fun, not serious >:(
jnese_translate = {
	a = "ka",
	b = "tu",
	c = "mi",
	d = "te",
	e = "ku",
	f = "lu",
	g = "ji",
	h = "ri",
	i = "ki",
	j = "zu",
	k = "me",
	l = "ta",
	m = "rin",
	n = "to",
	o = "mo",
	p = "no",
	q = "ke",
	r = "shi",
	s = "ari",
	t = "chi",
	u = "do",
	v = "ru",
	x = "na",
	w = "mei",
	y = "fu",
	z = "ra",
}

function jnese.get_letter(l)
	return jnese_translate[l] or l or ""
end

function jnese.DoMayusFirstLetter(str)
	local asus = string.sub(str, 1, 1)
	local usus = string.sub(str, 2)
	local isus = string.upper(asus)
	local esus = isus..usus
	return esus
end

function jnese.DoTransform(str)
	if str then
		local japanese = ""
		str:gsub(".", function(char)
			local n = "_"
			if char:byte() > 96 and char:byte() < 123 or char:byte() > 47 and char:byte() < 58 or char == "-" then
				n = jnese.get_letter(char)
			elseif char:byte() > 64 and char:byte() < 91 then
				n = jnese.DoMayusFirstLetter(jnese.get_letter(char:lower()))
			end
			japanese = japanese .. n
		end)
		return japanese
	end
end

function jnese.PlayerNameToJapanese(pname)
	return jnese.DoTransform(pname)
end

minetest.register_chatcommand("toggle_jp", {
	privs = {shout = true},
	params = "<theres nothing no specify>",
	description = "Toggle use of japanese lang",
	func = function(name)
		if jnese.players[name] then
			jnese.players[name] = false
			core.chat_send_player(name, "-!- Translate name to japanese: false")
		else
			jnese.players[name] = true
			core.chat_send_player(name, "-!- Translate name to japanese: true")
		end
	end,
})

minetest.register_on_chat_message(function(name, message)
	if jnese.players[name] then
		core.chat_send_all("<"..jnese.PlayerNameToJapanese(name).."> "..message)
		return true
	end
end)






