-- Generate lookup table for HTML entities out of https://html.spec.whatwg.org/entities.json
-- Requires https://github.com/brunoos/luasec to fetch the JSON
local https = require 'ssl.https'
local res, code = https.request"https://html.spec.whatwg.org/entities.json"
assert(code == 200)
local entity_map = {}
for entity, chars in pairs(assert(modlib.json:read_string(res))) do
	entity_map[entity:sub(2, #entity - 1)] = table.concat(modlib.table.map(chars.codepoints, modlib.utf8.char))
end
local entries = {}
for entity, chars in pairs(entity_map) do
	table.insert(entries, ("[%q] = %q"):format(entity, chars))
end
local serialized = [[-- HTML entity lookup table generated by build/html_entities.lua. Do not edit.
return {]] .. table.concat(entries, ", ") .. "}"
local loaded = assert(loadstring(serialized))
setfenv(loaded, {})
assert(modlib.table.equals(entity_map, loaded()))
modlib.file.write(modlib.mod.get_resource("modlib", "web", "html", "entities.lua"), serialized)