--blok
minetest.register_node("candy:candy_ore", {
    description = "Candy Ore",
    tiles = {"candy_ore.png"},
    groups = {cracky = 3},
	drop = "candy:candy_ore",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("candy:lolipop", {
	description = "Lolipop",
	drawtype = "torchlike",
	tiles = {"lolipop_svet.png"},
	inventory_image = "lolipop_item.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-3 / 16, -7 / 16, -3 / 16, 3 / 16, 6 / 16, 3 / 16}
	},
	groups = {dig_immediate = 3},
	on_use = minetest.item_eat(4),
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("candy:gelatine", {
	description = "Gelatine",
	drawtype = "plantlike",
	tiles = {"gelatine.png"},
	inventory_image = "gelatine.png",
	sunlight_propagates = true,
	walkable = false,
	groups = {dig_immediate = 3, fleshy = 3},
	on_use = minetest.item_eat(4),
	sound = {eat="default_ice_footstep"},
	sounds = {dug="default_ice_footstep"},
})

--item
minetest.register_craftitem("candy:candypis", {
	description = "Candy Piece",
	inventory_image = "candypis.png",
	sunlight_propagates = true,
	on_use = minetest.item_eat(1),
})

--ores
minetest.register_ore({
		ore_type       = "scatter",
		ore            = "candy:candy_ore",
		wherein        = "default:stone",
		clust_scarcity = 8 * 8 * 8,
		clust_num_ores = 5,
		clust_size     = 3,
		y_max          = 31000,
		y_min          = -31000,
})

--craft
minetest.register_craft({
	type = "cooking",
    output = "candy:gelatine",
	recipe = "candy:candy_ore",
	cooktime = 5.0,
})

minetest.register_craft({
    output = "candy_lolipop",
	recipe = {{"candy:candy_ore"},
			{"default:stick"},
			{"default:stick"},
	},
})

minetest.register_craft({
	type = "shapeless",
    output = "candy:candypis 4",
	recipe = {"candy:candy_ore"},
})

minetest.register_craft({
	type = "shapeless",
    output = "candy:candy_ore",
	recipe = {"candy:candypis","candy:candypis","candy:candypis","candy:candypis"},
})