/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;

public abstract class SocketHandler {
    protected final UpstreamReference<JDAImpl> api;
    protected long responseNumber;
    protected DataObject allContent;

    public SocketHandler(JDAImpl api) {
        this.api = new UpstreamReference<JDAImpl>(api);
    }

    public final synchronized void handle(long responseTotal, DataObject o) {
        this.allContent = o;
        this.responseNumber = responseTotal;
        Long guildId = this.handleInternally(o.getObject("d"));
        if (guildId != null) {
            this.getJDA().getGuildSetupController().cacheEvent(guildId, o);
        }
        this.allContent = null;
    }

    protected JDAImpl getJDA() {
        return this.api.get();
    }

    protected abstract Long handleInternally(DataObject var1);

    public static class NOPHandler
    extends SocketHandler {
        public NOPHandler(JDAImpl api) {
            super(api);
        }

        @Override
        protected Long handleInternally(DataObject content) {
            return null;
        }
    }
}

