/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.HierarchyException;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.managers.RoleManager;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.RoleAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.managers.RoleManagerImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;

public class RoleImpl
implements Role {
    private final long id;
    private final UpstreamReference<Guild> guild;
    private final ReentrantLock mngLock = new ReentrantLock();
    private volatile RoleManager manager;
    private String name;
    private boolean managed;
    private boolean hoisted;
    private boolean mentionable;
    private long rawPermissions;
    private int color;
    private int rawPosition;

    public RoleImpl(long id, Guild guild) {
        this.id = id;
        this.guild = new UpstreamReference<Guild>(guild);
    }

    @Override
    public int getPosition() {
        if (this == this.getGuild().getPublicRole()) {
            return -1;
        }
        int i = this.getGuild().getRoles().size() - 2;
        for (Role r : this.getGuild().getRoles()) {
            if (r == this) {
                return i;
            }
            --i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the role in the Guild's roles? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isHoisted() {
        return this.hoisted;
    }

    @Override
    public boolean isMentionable() {
        return this.mentionable;
    }

    @Override
    public long getPermissionsRaw() {
        return this.rawPermissions;
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissions() {
        return Permission.getPermissions(this.rawPermissions);
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissions(@Nonnull GuildChannel channel) {
        return Permission.getPermissions(PermissionUtil.getEffectivePermission(channel, this));
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissionsExplicit() {
        return this.getPermissions();
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissionsExplicit(@Nonnull GuildChannel channel) {
        return Permission.getPermissions(PermissionUtil.getExplicitPermission(channel, this));
    }

    @Override
    public Color getColor() {
        return this.color != 0x1FFFFFFF ? new Color(this.color) : null;
    }

    @Override
    public int getColorRaw() {
        return this.color;
    }

    @Override
    public boolean isPublicRole() {
        return this.equals(this.getGuild().getPublicRole());
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        long effectivePerms = this.rawPermissions | this.getGuild().getPublicRole().getPermissionsRaw();
        for (Permission perm : permissions) {
            long rawValue = perm.getRawValue();
            if ((effectivePerms & rawValue) == rawValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(@Nonnull Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean hasPermission(@Nonnull GuildChannel channel, Permission ... permissions) {
        long effectivePerms = PermissionUtil.getEffectivePermission(channel, this);
        for (Permission perm : permissions) {
            long rawValue = perm.getRawValue();
            if ((effectivePerms & rawValue) == rawValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(@Nonnull GuildChannel channel, @Nonnull Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean canInteract(@Nonnull Role role) {
        return PermissionUtil.canInteract(this, role);
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.guild.get();
    }

    @Override
    @Nonnull
    public RoleAction createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        return guild.createRole().setColor(this.color).setHoisted(this.hoisted).setMentionable(this.mentionable).setName(this.name).setPermissions(this.rawPermissions);
    }

    @Override
    @Nonnull
    public RoleManager getManager() {
        RoleManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new RoleManagerImpl(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (!this.getGuild().getSelfMember().hasPermission(Permission.MANAGE_ROLES)) {
            throw new InsufficientPermissionException(this.getGuild(), Permission.MANAGE_ROLES);
        }
        if (!PermissionUtil.canInteract(this.getGuild().getSelfMember(), (Role)this)) {
            throw new HierarchyException("Can't delete role >= highest self-role");
        }
        if (this.managed) {
            throw new UnsupportedOperationException("Cannot delete a Role that is managed. ");
        }
        Route.CompiledRoute route = Route.Roles.DELETE_ROLE.compile(this.getGuild().getId(), this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.getGuild().getJDA();
    }

    @Override
    @Nonnull
    public String getAsMention() {
        return this.isPublicRole() ? "@everyone" : "<@&" + this.getId() + '>';
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role oRole = (Role)o;
        return this.getIdLong() == oRole.getIdLong();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "R:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public int compareTo(Role r) {
        if (this == r) {
            return 0;
        }
        if (!this.getGuild().equals(r.getGuild())) {
            throw new IllegalArgumentException("Cannot compare roles that aren't from the same guild!");
        }
        if (this.getPositionRaw() != r.getPositionRaw()) {
            return this.getPositionRaw() - r.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getTimeCreated();
        OffsetDateTime rTime = r.getTimeCreated();
        return rTime.compareTo(thisTime);
    }

    public RoleImpl setName(String name) {
        this.name = name;
        return this;
    }

    public RoleImpl setColor(int color) {
        this.color = color;
        return this;
    }

    public RoleImpl setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    public RoleImpl setHoisted(boolean hoisted) {
        this.hoisted = hoisted;
        return this;
    }

    public RoleImpl setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public RoleImpl setRawPermissions(long rawPermissions) {
        this.rawPermissions = rawPermissions;
        return this;
    }

    public RoleImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }
}

