/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.internal.requests.Method;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;

public class Route {
    private final String route;
    private final String ratelimitRoute;
    private final String compilableRoute;
    private final int paramCount;
    private final Method method;
    private final List<Integer> majorParamIndexes = new ArrayList<Integer>();
    private final RateLimit ratelimit;
    private final boolean missingHeaders;

    private Route(Method method, String route, String ... majorParameters) {
        this(method, null, false, route, majorParameters);
    }

    private Route(Method method, RateLimit rateLimit, String route, String ... majorParameters) {
        this(method, rateLimit, false, route, majorParameters);
    }

    private Route(Method method, boolean missingHeaders, String route, String ... majorParameters) {
        this(method, null, missingHeaders, route, majorParameters);
    }

    private Route(Method method, RateLimit rateLimit, boolean missingHeaders, String route, String ... majorParameters) {
        this.method = method;
        this.missingHeaders = missingHeaders;
        this.ratelimit = rateLimit;
        this.route = route;
        this.paramCount = Helpers.countMatches(route, '{');
        if (this.paramCount != Helpers.countMatches(route, '}')) {
            throw new IllegalArgumentException("An argument does not have both {}'s for route: " + (Object)((Object)method) + "  " + route);
        }
        this.compilableRoute = route.replaceAll("\\{.*?\\}", "%s");
        if (majorParameters.length != 0) {
            int paramIndex = 0;
            String replaceRoute = route;
            Pattern keyP = Pattern.compile("\\{(.*?)\\}");
            Matcher keyM = keyP.matcher(route);
            while (keyM.find()) {
                String param = keyM.group(1);
                for (String majorParam : majorParameters) {
                    if (!param.equals(majorParam)) continue;
                    replaceRoute = replaceRoute.replace(keyM.group(0), "%s");
                    this.majorParamIndexes.add(paramIndex);
                }
                ++paramIndex;
            }
            this.ratelimitRoute = replaceRoute;
        } else {
            this.ratelimitRoute = route;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRoute() {
        return this.route;
    }

    public boolean isMissingHeaders() {
        return this.missingHeaders;
    }

    public String getRatelimitRoute() {
        return this.ratelimitRoute;
    }

    public final RateLimit getRatelimit() {
        return this.ratelimit;
    }

    public String getCompilableRoute() {
        return this.compilableRoute;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public CompiledRoute compile(String ... params) {
        if (params.length != this.paramCount) {
            throw new IllegalArgumentException("Error Compiling Route: [" + this.route + "], incorrect amount of parameters provided.Expected: " + this.paramCount + ", Provided: " + params.length);
        }
        String compiledRoute = String.format(this.compilableRoute, params);
        String compiledRatelimitRoute = this.getRatelimitRoute();
        if (!this.majorParamIndexes.isEmpty()) {
            String[] majorParams = new String[this.majorParamIndexes.size()];
            for (int i = 0; i < majorParams.length; ++i) {
                majorParams[i] = params[this.majorParamIndexes.get(i)];
            }
            compiledRatelimitRoute = String.format(compiledRatelimitRoute, majorParams);
        }
        return new CompiledRoute(this, compiledRatelimitRoute, compiledRoute);
    }

    public int hashCode() {
        return (this.route + this.method.toString()).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Route)) {
            return false;
        }
        Route oRoute = (Route)o;
        return this.method.equals((Object)oRoute.method) && this.route.equals(oRoute.route);
    }

    public String toString() {
        return "Route(" + (Object)((Object)this.method) + ": " + this.route + ")";
    }

    private static class ReactionRoute
    extends Route {
        private ReactionRoute(Method method) {
            super(method, new RateLimit(1, 250), "channels/{channel_id}/messages/{message_id}/reactions/{reaction_code}/{user_id}", new String[]{"channel_id"});
        }

        @Override
        public String getRatelimitRoute() {
            return "channels/%s/messages/{message_id}/reactions";
        }
    }

    private static class DeleteMessageRoute
    extends Route {
        private DeleteMessageRoute() {
            super(Method.DELETE, true, "channels/{channel_id}/messages/{message_id}", new String[]{"channel_id"});
        }

        @Override
        public String getRatelimitRoute() {
            return "channels/%s/messages/{message_id}/delete";
        }
    }

    public static class RateLimit {
        final int usageLimit;
        final int resetTime;

        public RateLimit(int usageLimit, int resetTime) {
            this.usageLimit = usageLimit;
            this.resetTime = resetTime;
        }

        public final int getUsageLimit() {
            return this.usageLimit;
        }

        public final int getResetTime() {
            return this.resetTime;
        }
    }

    public class CompiledRoute {
        private final Route baseRoute;
        private final String ratelimitRoute;
        private final String compiledRoute;
        private final boolean hasQueryParams;

        private CompiledRoute(Route baseRoute, String ratelimitRoute, String compiledRoute, boolean hasQueryParams) {
            this.baseRoute = baseRoute;
            this.ratelimitRoute = ratelimitRoute;
            this.compiledRoute = compiledRoute;
            this.hasQueryParams = hasQueryParams;
        }

        private CompiledRoute(Route baseRoute, String ratelimitRoute, String compiledRoute) {
            this(baseRoute, ratelimitRoute, compiledRoute, false);
        }

        public CompiledRoute withQueryParams(String ... params) {
            Checks.check(params.length >= 2, "params length must be at least 2");
            Checks.check(params.length % 2 == 0, "params length must be a multiple of 2");
            StringBuilder newRoute = new StringBuilder(this.compiledRoute);
            for (int i = 0; i < params.length; ++i) {
                newRoute.append((char)(!this.hasQueryParams && i == 0 ? 63 : 38)).append(params[i]).append('=').append(params[++i]);
            }
            return new CompiledRoute(this.baseRoute, this.ratelimitRoute, newRoute.toString(), true);
        }

        public String getRatelimitRoute() {
            return this.ratelimitRoute;
        }

        public String getCompiledRoute() {
            return this.compiledRoute;
        }

        public Route getBaseRoute() {
            return this.baseRoute;
        }

        public Method getMethod() {
            return this.baseRoute.method;
        }

        public int hashCode() {
            return (this.compiledRoute + Route.this.method.toString()).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CompiledRoute)) {
                return false;
            }
            CompiledRoute oCompiled = (CompiledRoute)o;
            return this.baseRoute.equals(oCompiled.getBaseRoute()) && this.compiledRoute.equals(oCompiled.compiledRoute);
        }

        public String toString() {
            return "CompiledRoute(" + (Object)((Object)Route.this.method) + ": " + this.compiledRoute + ")";
        }
    }

    public static class Custom {
        public static final Route DELETE_ROUTE = new Route(Method.DELETE, "{}", new String[0]);
        public static final Route GET_ROUTE = new Route(Method.GET, "{}", new String[0]);
        public static final Route POST_ROUTE = new Route(Method.POST, "{}", new String[0]);
        public static final Route PUT_ROUTE = new Route(Method.PUT, "{}", new String[0]);
        public static final Route PATCH_ROUTE = new Route(Method.PATCH, "{}", new String[0]);
    }

    public static class Invites {
        public static final Route GET_INVITE = new Route(Method.GET, true, "invites/{code}", new String[0]);
        public static final Route GET_GUILD_INVITES = new Route(Method.GET, true, "guilds/{guild_id}/invites", new String[]{"guild_id"});
        public static final Route GET_CHANNEL_INVITES = new Route(Method.GET, true, "channels/{channel_id}/invites", new String[]{"channel_id"});
        public static final Route CREATE_INVITE = new Route(Method.POST, "channels/{channel_id}/invites", new String[]{"channel_id"});
        public static final Route DELETE_INVITE = new Route(Method.DELETE, "invites/{code}", new String[0]);
    }

    public static class Messages {
        public static final Route SEND_MESSAGE = new Route(Method.POST, "channels/{channel_id}/messages", new String[]{"channel_id"});
        public static final Route EDIT_MESSAGE = new Route(Method.PATCH, "channels/{channel_id}/messages/{message_id}", new String[]{"channel_id"});
        public static final Route GET_PINNED_MESSAGES = new Route(Method.GET, "channels/{channel_id}/pins", new String[]{"channel_id"});
        public static final Route ADD_PINNED_MESSAGE = new Route(Method.PUT, "channels/{channel_id}/pins/{message_id}", new String[]{"channel_id"});
        public static final Route REMOVE_PINNED_MESSAGE = new Route(Method.DELETE, "channels/{channel_id}/pins/{message_id}", new String[]{"channel_id"});
        public static final Route ADD_REACTION = new ReactionRoute(Method.PUT);
        public static final Route REMOVE_REACTION = new ReactionRoute(Method.DELETE);
        public static final Route REMOVE_ALL_REACTIONS = new Route(Method.DELETE, new RateLimit(1, 250), "channels/{channel_id}/messages/{message_id}/reactions", new String[]{"channel_id"});
        public static final Route GET_REACTION_USERS = new Route(Method.GET, "channels/{channel_id}/messages/{message_id}/reactions/{reaction_code}", new String[]{"channel_id"});
        public static final Route DELETE_MESSAGE = new DeleteMessageRoute();
        public static final Route GET_MESSAGE_HISTORY = new Route(Method.GET, true, "channels/{channel_id}/messages", new String[]{"channel_id"});
        public static final Route GET_MESSAGE = new Route(Method.GET, true, "channels/{channel_id}/messages/{message_id}", new String[]{"channel_id"});
        public static final Route DELETE_MESSAGES = new Route(Method.POST, "channels/{channel_id}/messages/bulk-delete", new String[]{"channel_id"});
        public static final Route ACK_MESSAGE = new Route(Method.POST, "channels/{channel_id}/messages/{message_id}/ack", new String[0]);
    }

    public static class Channels {
        public static final Route DELETE_CHANNEL = new Route(Method.DELETE, true, "channels/{channel_id}", new String[]{"channel_id"});
        public static final Route MODIFY_CHANNEL = new Route(Method.PATCH, true, "channels/{channel_id}", new String[]{"channel_id"});
        public static final Route GET_WEBHOOKS = new Route(Method.GET, true, "channels/{channel_id}/webhooks", new String[]{"channel_id"});
        public static final Route CREATE_WEBHOOK = new Route(Method.POST, true, "channels/{channel_id}/webhooks", new String[]{"channel_id"});
        public static final Route CREATE_PERM_OVERRIDE = new Route(Method.PUT, true, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route MODIFY_PERM_OVERRIDE = new Route(Method.PUT, true, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route DELETE_PERM_OVERRIDE = new Route(Method.DELETE, true, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route SEND_TYPING = new Route(Method.POST, "channels/{channel_id}/typing", new String[]{"channel_id"});
        public static final Route GET_PERMISSIONS = new Route(Method.GET, "channels/{channel_id}/permissions", new String[]{"channel_id"});
        public static final Route GET_PERM_OVERRIDE = new Route(Method.GET, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route GET_RECIPIENTS = new Route(Method.GET, "channels/{channel_id}/recipients", new String[0]);
        public static final Route GET_RECIPIENT = new Route(Method.GET, "channels/{channel_id}/recipients/{user_id}", new String[0]);
        public static final Route ADD_RECIPIENT = new Route(Method.PUT, "channels/{channel_id}/recipients/{user_id}", new String[0]);
        public static final Route REMOVE_RECIPIENT = new Route(Method.DELETE, "channels/{channel_id}/recipients/{user_id}", new String[0]);
        public static final Route START_CALL = new Route(Method.POST, "channels/{channel_id}/call/ring", new String[0]);
        public static final Route STOP_CALL = new Route(Method.POST, "channels/{channel_id}/call/stop_ringing", new String[0]);
    }

    public static class Roles {
        public static final Route GET_ROLES = new Route(Method.GET, "guilds/{guild_id}/roles", new String[]{"guild_id"});
        public static final Route CREATE_ROLE = new Route(Method.POST, "guilds/{guild_id}/roles", new String[]{"guild_id"});
        public static final Route GET_ROLE = new Route(Method.GET, "guilds/{guild_id}/roles/{role_id}", new String[]{"guild_id"});
        public static final Route MODIFY_ROLE = new Route(Method.PATCH, "guilds/{guild_id}/roles/{role_id}", new String[]{"guild_id"});
        public static final Route DELETE_ROLE = new Route(Method.DELETE, "guilds/{guild_id}/roles/{role_id}", new String[]{"guild_id"});
    }

    public static class Webhooks {
        public static final Route GET_WEBHOOK = new Route(Method.GET, true, "webhooks/{webhook_id}", new String[0]);
        public static final Route GET_TOKEN_WEBHOOK = new Route(Method.GET, true, "webhooks/{webhook_id}/{token}", new String[0]);
        public static final Route DELETE_WEBHOOK = new Route(Method.DELETE, true, "webhooks/{webhook_id}", new String[0]);
        public static final Route DELETE_TOKEN_WEBHOOK = new Route(Method.DELETE, true, "webhooks/{webhook_id}/{token}", new String[0]);
        public static final Route MODIFY_WEBHOOK = new Route(Method.PATCH, true, "webhooks/{webhook_id}", new String[0]);
        public static final Route MODIFY_TOKEN_WEBHOOK = new Route(Method.PATCH, true, "webhooks/{webhook_id}/{token}", new String[0]);
        public static final Route EXECUTE_WEBHOOK = new Route(Method.POST, "webhooks/{webhook_id}/{token}", new String[]{"webhook_id"});
        public static final Route EXECUTE_WEBHOOK_SLACK = new Route(Method.POST, "webhooks/{webhook_id}/{token}/slack", new String[]{"webhook_id"});
        public static final Route EXECUTE_WEBHOOK_GITHUB = new Route(Method.POST, "webhooks/{webhook_id}/{token}/github", new String[]{"webhook_id"});
    }

    public static class Emotes {
        public static final Route MODIFY_EMOTE = new Route(Method.PATCH, true, "guilds/{guild_id}/emojis/{emote_id}", new String[]{"guild_id"});
        public static final Route DELETE_EMOTE = new Route(Method.DELETE, true, "guilds/{guild_id}/emojis/{emote_id}", new String[]{"guild_id"});
        public static final Route CREATE_EMOTE = new Route(Method.POST, true, "guilds/{guild_id}/emojis", new String[]{"guild_id"});
        public static final Route GET_EMOTES = new Route(Method.GET, true, "guilds/{guild_id}/emojis", new String[]{"guild_id"});
        public static final Route GET_EMOTE = new Route(Method.GET, true, "guilds/{guild_id}/emojis/{emoji_id}", new String[]{"guild_id"});
    }

    public static class Guilds {
        public static final Route GET_GUILD = new Route(Method.GET, "guilds/{guild_id}", new String[]{"guild_id"});
        public static final Route MODIFY_GUILD = new Route(Method.PATCH, "guilds/{guild_id}", new String[]{"guild_id"});
        public static final Route GET_VANITY_URL = new Route(Method.GET, "guilds/{guild_id}/vanity-url", new String[]{"guild_id"});
        public static final Route CREATE_CHANNEL = new Route(Method.POST, "guilds/{guild_id}/channels", new String[]{"guild_id"});
        public static final Route GET_CHANNELS = new Route(Method.GET, "guilds/{guild_id}/channels", new String[]{"guild_id"});
        public static final Route MODIFY_CHANNELS = new Route(Method.PATCH, "guilds/{guild_id}/channels", new String[]{"guild_id"});
        public static final Route MODIFY_ROLES = new Route(Method.PATCH, "guilds/{guild_id}/roles", new String[]{"guild_id"});
        public static final Route GET_BANS = new Route(Method.GET, "guilds/{guild_id}/bans", new String[]{"guild_id"});
        public static final Route GET_BAN = new Route(Method.GET, "guilds/{guild_id}/bans/{user_id}", new String[]{"guild_id"});
        public static final Route UNBAN = new Route(Method.DELETE, "guilds/{guild_id}/bans/{user_id}", new String[]{"guild_id"});
        public static final Route BAN = new Route(Method.PUT, "guilds/{guild_id}/bans/{user_id}", new String[]{"guild_id"});
        public static final Route KICK_MEMBER = new Route(Method.DELETE, "guilds/{guild_id}/members/{user_id}", new String[]{"guild_id"});
        public static final Route MODIFY_MEMBER = new Route(Method.PATCH, "guilds/{guild_id}/members/{user_id}", new String[]{"guild_id"});
        public static final Route ADD_MEMBER = new Route(Method.PUT, "guilds/{guild_id}/members/{user_id}", new String[]{"guild_id"});
        public static final Route MODIFY_SELF_NICK = new Route(Method.PATCH, "guilds/{guild_id}/members/@me/nick", new String[]{"guild_id"});
        public static final Route PRUNABLE_COUNT = new Route(Method.GET, "guilds/{guild_id}/prune", new String[]{"guild_id"});
        public static final Route PRUNE_MEMBERS = new Route(Method.POST, "guilds/{guild_id}/prune", new String[]{"guild_id"});
        public static final Route GET_WEBHOOKS = new Route(Method.GET, "guilds/{guild_id}/webhooks", new String[]{"guild_id"});
        public static final Route GET_GUILD_EMBED = new Route(Method.GET, "guilds/{guild_id}/embed", new String[]{"guild_id"});
        public static final Route MODIFY_GUILD_EMBED = new Route(Method.PATCH, "guilds/{guild_id}/embed", new String[]{"guild_id"});
        public static final Route GET_GUILD_EMOTES = new Route(Method.GET, "guilds/{guild_id}/emojis", new String[]{"guild_id"});
        public static final Route GET_AUDIT_LOGS = new Route(Method.GET, true, "guilds/{guild_id}/audit-logs", new String[]{"guild_id"});
        public static final Route GET_VOICE_REGIONS = new Route(Method.GET, true, "guilds/{guild_id}/regions", new String[]{"guild_id"});
        public static final Route GET_INTEGRATIONS = new Route(Method.GET, "guilds/{guild_id}/integrations", new String[]{"guild_id"});
        public static final Route CREATE_INTEGRATION = new Route(Method.POST, "guilds/{guild_id}/integrations", new String[]{"guild_id"});
        public static final Route DELETE_INTEGRATION = new Route(Method.DELETE, "guilds/{guild_id}/integrations/{integration_id}", new String[]{"guild_id"});
        public static final Route MODIFY_INTEGRATION = new Route(Method.PATCH, "guilds/{guild_id}/integrations/{integration_id}", new String[]{"guild_id"});
        public static final Route SYNC_INTEGRATION = new Route(Method.POST, "guilds/{guild_id}/integrations/{integration_id}/sync", new String[]{"guild_id"});
        public static final Route ADD_MEMBER_ROLE = new Route(Method.PUT, "guilds/{guild_id}/members/{user_id}/roles/{role_id}", new String[]{"guild_id"});
        public static final Route REMOVE_MEMBER_ROLE = new Route(Method.DELETE, "guilds/{guild_id}/members/{user_id}/roles/{role_id}", new String[]{"guild_id"});
        public static final Route CREATE_GUILD = new Route(Method.POST, "guilds", new String[0]);
        public static final Route DELETE_GUILD = new Route(Method.POST, "guilds/{guild_id}/delete", new String[0]);
        public static final Route ACK_GUILD = new Route(Method.POST, "guilds/{guild_id}/ack", new String[0]);
        public static final Route MODIFY_NOTIFICATION_SETTINGS = new Route(Method.PATCH, "users/@me/guilds/{guild_id}/settings", new String[0]);
    }

    public static class Relationships {
        public static final Route GET_RELATIONSHIPS = new Route(Method.GET, "users/@me/relationships", new String[0]);
        public static final Route GET_RELATIONSHIP = new Route(Method.GET, "users/@me/relationships/{user_id}", new String[0]);
        public static final Route ADD_RELATIONSHIP = new Route(Method.PUT, "users/@me/relationships/{user_id}", new String[0]);
        public static final Route DELETE_RELATIONSHIP = new Route(Method.DELETE, "users/@me/relationships/{user_id}", new String[0]);
    }

    public static class Users {
        public static final Route GET_USER = new Route(Method.GET, "users/{user_id}", new String[0]);
        public static final Route GET_PROFILE = new Route(Method.GET, "users/{user_id}/profile", new String[0]);
        public static final Route GET_NOTE = new Route(Method.GET, "users/@me/notes/{user_id}", new String[0]);
        public static final Route SET_NOTE = new Route(Method.PUT, "users/@me/notes/{user_id}", new String[0]);
    }

    public static class Self {
        public static final Route GET_SELF = new Route(Method.GET, true, "users/@me", new String[0]);
        public static final Route MODIFY_SELF = new Route(Method.PATCH, "users/@me", new String[0]);
        public static final Route GET_GUILDS = new Route(Method.GET, "users/@me/guilds", new String[0]);
        public static final Route LEAVE_GUILD = new Route(Method.DELETE, "users/@me/guilds/{guild_id}", new String[0]);
        public static final Route GET_PRIVATE_CHANNELS = new Route(Method.GET, "users/@me/channels", new String[0]);
        public static final Route CREATE_PRIVATE_CHANNEL = new Route(Method.POST, "users/@me/channels", new String[0]);
        public static final Route USER_SETTINGS = new Route(Method.GET, "users/@me/settings", new String[0]);
        public static final Route GET_CONNECTIONS = new Route(Method.GET, "users/@me/connections", new String[0]);
        public static final Route FRIEND_SUGGESTIONS = new Route(Method.GET, "friend-suggestions", new String[0]);
        public static final Route GET_RECENT_MENTIONS = new Route(Method.GET, "users/@me/mentions", new String[0]);
    }

    public static class Applications {
        public static final Route GET_BOT_APPLICATION = new Route(Method.GET, "oauth2/applications/@me", new String[0]);
        public static final Route GET_APPLICATIONS = new Route(Method.GET, "oauth2/applications", new String[0]);
        public static final Route CREATE_APPLICATION = new Route(Method.POST, "oauth2/applications", new String[0]);
        public static final Route GET_APPLICATION = new Route(Method.GET, "oauth2/applications/{application_id}", new String[0]);
        public static final Route MODIFY_APPLICATION = new Route(Method.PUT, "oauth2/applications/{application_id}", new String[0]);
        public static final Route DELETE_APPLICATION = new Route(Method.DELETE, "oauth2/applications/{application_id}", new String[0]);
        public static final Route CREATE_BOT = new Route(Method.POST, "oauth2/applications/{application_id}/bot", new String[0]);
        public static final Route RESET_APPLICATION_SECRET = new Route(Method.POST, "oauth2/applications/{application_id}/reset", new String[0]);
        public static final Route RESET_BOT_TOKEN = new Route(Method.POST, "oauth2/applications/{application_id}/bot/reset", new String[0]);
        public static final Route GET_AUTHORIZED_APPLICATIONS = new Route(Method.GET, "oauth2/tokens", new String[0]);
        public static final Route GET_AUTHORIZED_APPLICATION = new Route(Method.GET, "oauth2/tokens/{auth_id}", new String[0]);
        public static final Route DELETE_AUTHORIZED_APPLICATION = new Route(Method.DELETE, "oauth2/tokens/{auth_id}", new String[0]);
    }

    public static class Misc {
        public static final Route TRACK = new Route(Method.POST, true, "track", new String[0]);
        public static final Route GET_VOICE_REGIONS = new Route(Method.GET, true, "voice/regions", new String[0]);
        public static final Route GATEWAY = new Route(Method.GET, true, "gateway", new String[0]);
        public static final Route GATEWAY_BOT = new Route(Method.GET, true, "gateway/bot", new String[0]);
    }
}

