/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class ReadyHandler
extends SocketHandler {
    public ReadyHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        DataArray guilds = content.getArray("guilds");
        DataObject selfJson = content.getObject("user");
        builder.createSelfUser(selfJson);
        if (this.getJDA().getGuildSetupController().setIncompleteCount(guilds.length())) {
            for (int i = 0; i < guilds.length(); ++i) {
                DataObject guild = guilds.getObject(i);
                this.getJDA().getGuildSetupController().onReady(guild.getLong("id"), guild);
            }
        }
        this.handleReady(content);
        return null;
    }

    public void handleReady(DataObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        DataArray privateChannels = content.getArray("private_channels");
        block3: for (int i = 0; i < privateChannels.length(); ++i) {
            DataObject chan = privateChannels.getObject(i);
            ChannelType type = ChannelType.fromId(chan.getInt("type"));
            switch (type) {
                case PRIVATE: {
                    builder.createPrivateChannel(chan);
                    continue block3;
                }
                default: {
                    WebSocketClient.LOG.warn("Received a Channel in the private_channels array in READY of an unknown type! Type: {}", (Object)type);
                }
            }
        }
    }
}

