/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests.restaction;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.internal.requests.restaction.MessageActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface MessageAction
extends RestAction<Message>,
Appendable {
    public static void setDefaultMentions(@Nullable Collection<Message.MentionType> allowedMentions) {
        MessageActionImpl.setDefaultMentions(allowedMentions);
    }

    @Nonnull
    public static EnumSet<Message.MentionType> getDefaultMentions() {
        return MessageActionImpl.getDefaultMentions();
    }

    @Nonnull
    public MessageAction setCheck(@Nullable BooleanSupplier var1);

    @Nonnull
    public MessageAction timeout(long var1, @Nonnull TimeUnit var3);

    @Nonnull
    public MessageAction deadline(long var1);

    @Nonnull
    public MessageChannel getChannel();

    public boolean isEmpty();

    public boolean isEdit();

    @Nonnull
    @CheckReturnValue
    public MessageAction apply(@Nullable Message var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction tts(boolean var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction reset();

    @Nonnull
    @CheckReturnValue
    public MessageAction nonce(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction content(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction embed(@Nullable MessageEmbed var1);

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction append(@Nonnull CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageAction append(@Nullable CharSequence var1, int var2, int var3);

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageAction append(char var1);

    @Nonnull
    @CheckReturnValue
    default public MessageAction appendFormat(@Nonnull String format, Object ... args) {
        return this.append(String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    public MessageAction addFile(@Nonnull InputStream var1, @Nonnull String var2, AttachmentOption ... var3);

    @Nonnull
    @CheckReturnValue
    default public MessageAction addFile(@Nonnull byte[] data, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(data, "Data");
        long maxSize = this.getJDA().getSelfUser().getAllowedFileSize();
        Checks.check((long)data.length <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        return this.addFile(new ByteArrayInputStream(data), name, options);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageAction addFile(@Nonnull File file, AttachmentOption ... options) {
        Checks.notNull(file, "File");
        return this.addFile(file, file.getName(), options);
    }

    @Nonnull
    @CheckReturnValue
    public MessageAction addFile(@Nonnull File var1, @Nonnull String var2, AttachmentOption ... var3);

    @Nonnull
    @CheckReturnValue
    public MessageAction clearFiles();

    @Nonnull
    @CheckReturnValue
    public MessageAction clearFiles(@Nonnull BiConsumer<String, InputStream> var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction clearFiles(@Nonnull Consumer<InputStream> var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction override(boolean var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction allowedMentions(@Nullable Collection<Message.MentionType> var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction mention(IMentionable ... var1);

    @Nonnull
    @CheckReturnValue
    default public MessageAction mention(@Nonnull Collection<? extends IMentionable> mentions) {
        Checks.noneNull(mentions, "Mention");
        return this.mention(mentions.toArray(new IMentionable[0]));
    }

    @Nonnull
    @CheckReturnValue
    public MessageAction mentionUsers(String ... var1);

    @Nonnull
    @CheckReturnValue
    default public MessageAction mentionUsers(long ... userIds) {
        Checks.notNull(userIds, "UserId array");
        String[] stringIds = new String[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            stringIds[i] = Long.toUnsignedString(userIds[i]);
        }
        return this.mentionUsers(stringIds);
    }

    @Nonnull
    @CheckReturnValue
    public MessageAction mentionRoles(String ... var1);

    @Nonnull
    @CheckReturnValue
    default public MessageAction mentionRoles(long ... roleIds) {
        Checks.notNull(roleIds, "RoleId array");
        String[] stringIds = new String[roleIds.length];
        for (int i = 0; i < roleIds.length; ++i) {
            stringIds[i] = Long.toUnsignedString(roleIds[i]);
        }
        return this.mentionRoles(stringIds);
    }
}

