/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IFakeable;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.requests.RestAction;

public interface User
extends IMentionable,
IFakeable {
    public static final Pattern USER_TAG = Pattern.compile("(.{2,32})#(\\d{4})");
    public static final String AVATAR_URL = "https://cdn.discordapp.com/avatars/%s/%s.%s";
    public static final String DEFAULT_AVATAR_URL = "https://cdn.discordapp.com/embed/avatars/%s.png";

    @Nonnull
    public String getName();

    @Nonnull
    public String getDiscriminator();

    @Nullable
    public String getAvatarId();

    @Nullable
    default public String getAvatarUrl() {
        String avatarId = this.getAvatarId();
        return avatarId == null ? null : String.format(AVATAR_URL, this.getId(), avatarId, avatarId.startsWith("a_") ? "gif" : "png");
    }

    @Nonnull
    public String getDefaultAvatarId();

    @Nonnull
    default public String getDefaultAvatarUrl() {
        return String.format(DEFAULT_AVATAR_URL, this.getDefaultAvatarId());
    }

    @Nonnull
    default public String getEffectiveAvatarUrl() {
        String avatarUrl = this.getAvatarUrl();
        return avatarUrl == null ? this.getDefaultAvatarUrl() : avatarUrl;
    }

    @Nonnull
    public String getAsTag();

    public boolean hasPrivateChannel();

    @Nonnull
    @CheckReturnValue
    public RestAction<PrivateChannel> openPrivateChannel();

    @Nonnull
    public List<Guild> getMutualGuilds();

    public boolean isBot();

    @Nonnull
    public JDA getJDA();
}

