/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.StoreChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.InviteAction;
import net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.requests.EmptyRestAction;
import net.dv8tion.jda.internal.utils.Checks;

public class CategoryImpl
extends AbstractChannelImpl<Category, CategoryImpl>
implements Category {
    protected final TLongObjectMap<GuildChannel> channels = MiscUtil.newLongMap();

    public CategoryImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public Category getParent() {
        return null;
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return ChannelType.CATEGORY;
    }

    @Override
    @Nonnull
    public List<Member> getMembers() {
        return Collections.unmodifiableList(this.getChannels().stream().map(GuildChannel::getMembers).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<Category> channels = this.getGuild().getCategories();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the Category in the Guild's channels? wtf?");
    }

    @Override
    @Nonnull
    public ChannelAction<Category> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<Category> action = guild.createCategory(this.name);
        if (guild.equals(this.getGuild())) {
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addPermissionOverride((IPermissionHolder)o.getMember(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addPermissionOverride((IPermissionHolder)o.getRole(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    @Nonnull
    public InviteAction createInvite() {
        throw new UnsupportedOperationException("Cannot create invites for category!");
    }

    @Override
    @Nonnull
    public RestAction<List<Invite>> retrieveInvites() {
        return new EmptyRestAction<List<Invite>>(this.getJDA(), Collections.emptyList());
    }

    @Override
    @Nonnull
    public List<GuildChannel> getChannels() {
        ArrayList<GuildChannel> channels = new ArrayList<GuildChannel>();
        channels.addAll(this.getStoreChannels());
        channels.addAll(this.getTextChannels());
        channels.addAll(this.getVoiceChannels());
        Collections.sort(channels);
        return Collections.unmodifiableList(channels);
    }

    @Override
    @Nonnull
    public List<StoreChannel> getStoreChannels() {
        return Collections.unmodifiableList(this.getGuild().getStoreChannelCache().stream().filter(channel -> this.equals(channel.getParent())).sorted().collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(this.getGuild().getTextChannels().stream().filter(channel -> this.equals(channel.getParent())).sorted().collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(this.getGuild().getVoiceChannels().stream().filter(channel -> this.equals(channel.getParent())).sorted().collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public ChannelAction<TextChannel> createTextChannel(@Nonnull String name) {
        ChannelAction<TextChannel> action = this.getGuild().createTextChannel(name).setParent(this);
        this.applyPermission(action);
        return action;
    }

    @Override
    @Nonnull
    public ChannelAction<VoiceChannel> createVoiceChannel(@Nonnull String name) {
        ChannelAction<VoiceChannel> action = this.getGuild().createVoiceChannel(name).setParent(this);
        this.applyPermission(action);
        return action;
    }

    @Override
    @Nonnull
    public CategoryOrderAction modifyTextChannelPositions() {
        return this.getGuild().modifyTextChannelPositions(this);
    }

    @Override
    @Nonnull
    public CategoryOrderAction modifyVoiceChannelPositions() {
        return this.getGuild().modifyVoiceChannelPositions(this);
    }

    public String toString() {
        return "GC:" + this.getName() + '(' + this.id + ')';
    }

    private void applyPermission(ChannelAction a) {
        this.overrides.forEachValue(override -> {
            if (override.isMemberOverride()) {
                a.addPermissionOverride((IPermissionHolder)override.getMember(), override.getAllowedRaw(), override.getDeniedRaw());
            } else {
                a.addPermissionOverride((IPermissionHolder)override.getRole(), override.getAllowedRaw(), override.getDeniedRaw());
            }
            return true;
        });
    }
}

