/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.PermissionOverrideActionImpl;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;

public class PermissionOverrideImpl
implements PermissionOverride {
    private final long id;
    private final UpstreamReference<GuildChannel> channel;
    private final IPermissionHolder permissionHolder;
    protected final ReentrantLock mngLock = new ReentrantLock();
    protected volatile PermissionOverrideAction manager;
    private long allow;
    private long deny;

    public PermissionOverrideImpl(GuildChannel channel, long id, IPermissionHolder permissionHolder) {
        this.channel = new UpstreamReference<GuildChannel>(channel);
        this.id = id;
        this.permissionHolder = permissionHolder;
    }

    @Override
    public long getAllowedRaw() {
        return this.allow;
    }

    @Override
    public long getInheritRaw() {
        return (this.allow | this.deny) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getDeniedRaw() {
        return this.deny;
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getAllowed() {
        return Permission.getPermissions(this.allow);
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getInherit() {
        return Permission.getPermissions(this.getInheritRaw());
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getDenied() {
        return Permission.getPermissions(this.deny);
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.getChannel().getJDA();
    }

    @Override
    public Member getMember() {
        return this.isMemberOverride() ? (Member)this.permissionHolder : null;
    }

    @Override
    public Role getRole() {
        return this.isRoleOverride() ? (Role)this.permissionHolder : null;
    }

    @Override
    @Nonnull
    public GuildChannel getChannel() {
        return this.channel.get();
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    @Override
    public boolean isMemberOverride() {
        return this.permissionHolder instanceof Member;
    }

    @Override
    public boolean isRoleOverride() {
        return this.permissionHolder instanceof Role;
    }

    @Override
    @Nonnull
    public PermissionOverrideAction getManager() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(this.getChannel(), Permission.MANAGE_PERMISSIONS);
        }
        PermissionOverrideAction mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new PermissionOverrideActionImpl(this).setOverride(false);
                }
                return this.manager;
            });
        }
        return mng.reset();
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(this.getChannel(), Permission.MANAGE_PERMISSIONS);
        }
        String targetId = this.isRoleOverride() ? this.getRole().getId() : this.getMember().getUser().getId();
        Route.CompiledRoute route = Route.Channels.DELETE_PERM_OVERRIDE.compile(this.getChannel().getId(), targetId);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    public PermissionOverrideImpl setAllow(long allow) {
        this.allow = allow;
        return this;
    }

    public PermissionOverrideImpl setDeny(long deny) {
        this.deny = deny;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermissionOverrideImpl)) {
            return false;
        }
        PermissionOverrideImpl oPerm = (PermissionOverrideImpl)o;
        return this.permissionHolder.equals(oPerm.permissionHolder) && this.getChannel().equals(oPerm.getChannel());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "PermOver:(" + (this.isMemberOverride() ? "M" : "R") + ")(" + this.getChannel().getId() + " | " + this.id + ")";
    }
}

