/*
 * Decompiled with CFR 0.152.
 */
package irc;

import appguru.Main;
import handlers.ResponseHandler;
import handlers.TryAgainHandler;
import irc.Command;
import irc.Default;
import irc.HandledResponse;
import irc.InvalidMessageException;
import irc.PongCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class IRCBot {
    public Map<String, commands.Command> chatcommands;
    public Map<String, Command> commands;
    public Default default_command;
    public List<ResponseHandler> responseHandlers = new ArrayList<ResponseHandler>();
    public Socket socket;

    public IRCBot(int port, String server, boolean ssl) throws IOException {
        this.default_command = (bot, commandname, tags, source, params) -> {};
        this.chatcommands = new HashMap<String, commands.Command>();
        this.commands = new HashMap<String, Command>();
        this.commands.put("PING", new PongCommand());
        if (ssl) {
            try {
                SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket s = (SSLSocket)ssf.createSocket(server, port);
                s.startHandshake();
                this.socket = s;
            }
            catch (Exception e) {
                Main.OUT.println("ERR: Could not create SSL socket (" + e.getMessage() + ") !");
            }
        } else {
            this.socket = new Socket(server, port);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace(Main.OUT);
                }
            }
        }));
    }

    public void join(String channelname) throws IOException {
        this.send("JOIN " + channelname);
    }

    public void join(String channelname, String key) throws IOException {
        this.send("JOIN " + channelname + " " + key);
    }

    public void leave(String channelname, String reason) throws IOException {
        this.send("PART " + channelname + " " + reason);
    }

    public void processMessage(String message) throws InvalidMessageException {
        block26: {
            ArrayList<String> params;
            String commandname;
            String source;
            HashMap<String, Object> tags;
            block25: {
                int nextSpace;
                tags = new HashMap<String, Object>();
                int i = 0;
                if (message.charAt(0) == '@') {
                    Object tagname = "";
                    Object tagcontent = "";
                    boolean after_equals_sign = false;
                    ++i;
                    block10: while (i < message.length()) {
                        char c = message.charAt(i);
                        switch (c) {
                            case '=': {
                                after_equals_sign = true;
                                break;
                            }
                            case ';': {
                                if (after_equals_sign) {
                                    tags.put((String)tagname, tagcontent);
                                } else {
                                    tags.put((String)tagname, true);
                                }
                                after_equals_sign = false;
                                tagname = "";
                                tagcontent = "";
                                break;
                            }
                            case ' ': {
                                break block10;
                            }
                            default: {
                                if (after_equals_sign) {
                                    tagcontent = (String)tagcontent + c;
                                    break;
                                }
                                tagname = (String)tagname + c;
                            }
                        }
                        ++i;
                    }
                    ++i;
                }
                source = null;
                if (message.charAt(i) == ':') {
                    int nextSpace2 = message.indexOf(32, i + 1);
                    if (nextSpace2 < 0) {
                        throw new InvalidMessageException("Source part doesn't end.");
                    }
                    source = message.substring(i + 1, nextSpace2);
                    i = nextSpace2;
                    ++i;
                }
                if ((nextSpace = message.indexOf(32, i + 1)) < 0) {
                    throw new InvalidMessageException("Command part doesn't end.");
                }
                commandname = message.substring(i, nextSpace);
                params = new ArrayList<String>();
                Object param = "";
                if (message.charAt(++nextSpace) == ':') {
                    params.add(message.substring(nextSpace + 1));
                } else {
                    for (int j = nextSpace; j < message.length(); ++j) {
                        if (message.charAt(j) == ' ') {
                            params.add((String)param);
                            if (message.charAt(j + 1) == ':') {
                                params.add(message.substring(j + 2));
                                break block25;
                            }
                            param = "";
                            continue;
                        }
                        param = (String)param + message.charAt(j);
                    }
                    params.add((String)param);
                }
            }
            int k = this.responseHandlers.size() - 1;
            while (k >= 0) {
                ResponseHandler handler = this.responseHandlers.get(k);
                HandledResponse handled = handler.handle(this, commandname, tags, source, params);
                switch (handled) {
                    case BREAK: {
                        break block26;
                    }
                    case RETURN: {
                        this.responseHandlers.remove(k);
                        break block26;
                    }
                    case KILL: {
                        this.responseHandlers.remove(k);
                    }
                    default: {
                        --k;
                        break;
                    }
                }
            }
            Command command = this.commands.get(commandname);
            if (command == null) {
                this.default_command.execute(this, commandname, tags, source, params);
                return;
            }
            command.execute(this, tags, source, params);
        }
    }

    public void listen() {
        Thread listenerThread = new Thread(() -> {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace(Main.OUT);
                if (this.socket.isClosed() || this.socket.isInputShutdown() || this.socket.isOutputShutdown()) {
                    Main.PROCESS_BRIDGE.kill("Socket connection lost");
                }
                System.exit(1);
            }
            block8: while (true) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    while (true) {
                        String message;
                        if ((message = reader.readLine()) == null) continue block8;
                        try {
                            this.processMessage(message);
                        }
                        catch (InvalidMessageException e) {
                            e.printStackTrace(Main.OUT);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(Main.OUT);
                    if (!this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown()) continue;
                    Main.PROCESS_BRIDGE.kill("Socket connection lost");
                    continue;
                }
                break;
            }
        });
        listenerThread.start();
    }

    public void send(String message) throws IOException {
        if (this.socket.isClosed() || this.socket.isOutputShutdown()) {
            Main.PROCESS_BRIDGE.kill("Socket connection lost");
        }
        this.socket.getOutputStream().write(message.getBytes("UTF-8"));
        this.socket.getOutputStream().write(13);
        this.socket.getOutputStream().write(10);
    }

    public void send(String message, ResponseHandler response_handler) throws IOException {
        this.send(message);
        this.responseHandlers.add(response_handler);
    }

    public void sendTryAgain(String command) {
        try {
            this.send(command, new TryAgainHandler(command));
        }
        catch (IOException e) {
            e.printStackTrace(Main.OUT);
        }
    }

    public void shutdown(String reason) {
        try {
            this.send("QUIT :" + reason);
        }
        catch (IOException e) {
            e.printStackTrace(Main.OUT);
        }
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace(Main.OUT);
            }
        }
    }
}

