/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import appguru.Main;
import bridge.ProcessBridge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Consumer;

public class FileBridge
extends ProcessBridge {
    public File out_file;
    public File in;
    public PrintWriter out;
    private long last_ping_sent;

    public FileBridge(File in, File out) throws IOException {
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(out, true)));
        this.out_file = out;
        this.in = in;
        this.last_ping_sent = System.currentTimeMillis();
    }

    @Override
    public void kill(String reason) {
        Main.OUT.println("INFO: " + reason);
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.in);
            fw.write("");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace(Main.OUT);
        }
        Main.OUT.close();
        this.out.write("[KIL]" + reason);
        this.out.close();
        System.exit(0);
    }

    @Override
    public void write(String out) {
        this.out.println(out);
    }

    @Override
    public void serve() {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(Main.OUT);
                    }
                    if (System.currentTimeMillis() - FileBridge.this.last_ping_sent >= 1000L) {
                        FileBridge.this.out.write("[PIN]");
                    }
                    FileBridge.this.out.flush();
                    FileBridge.this.out.close();
                    try {
                        FileBridge.this.out = new PrintWriter(new BufferedWriter(new FileWriter(FileBridge.this.out_file, true)));
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace(Main.OUT);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void listen(Consumer<String> line_consumer) {
        this.ping();
        new Thread(() -> {
            while (true) {
                boolean one_line;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Main.OUT);
                }
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(this.in));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(Main.OUT);
                }
                String line = null;
                try {
                    line = r.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace(Main.OUT);
                }
                boolean bl = one_line = line != null;
                while (line != null) {
                    if (line.startsWith("[PIN]")) {
                        this.ping();
                    } else if (line.startsWith("[KIL]")) {
                        this.kill("Minetest server shutting down; shutting down as well.");
                    } else {
                        line_consumer.accept(line);
                    }
                    try {
                        line = r.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace(Main.OUT);
                    }
                }
                if (System.currentTimeMillis() - this.last_ping > Main.PING_WAIT) {
                    this.kill("No ping during the last " + Main.PING_WAIT / 1000L + "s; shutting down.");
                }
                if (!one_line) continue;
                try {
                    FileWriter fw = new FileWriter(this.in);
                    fw.write("");
                    fw.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace(Main.OUT);
                    continue;
                }
                break;
            }
        }).start();
    }
}

