/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import appguru.Main;
import bridge.ProcessBridge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.function.Consumer;

public class SocketBridge
extends ProcessBridge {
    private Socket socket = new Socket();
    private final BufferedWriter writer;
    private BufferedReader reader;

    public SocketBridge(String host, int port) throws IOException {
        this.socket.connect(new InetSocketAddress(host, port));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
    }

    @Override
    public void kill(String reason) {
        Main.OUT.println("INFO: " + reason);
        if (this.socket.isConnected()) {
            try {
                this.writer.write("[KIL]" + reason);
            }
            catch (IOException ex) {
                ex.printStackTrace(Main.OUT);
            }
        }
        try {
            this.writer.close();
            this.reader.close();
            this.socket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(Main.OUT);
        }
        finally {
            Main.OUT.close();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String out) {
        BufferedWriter bufferedWriter = this.writer;
        synchronized (bufferedWriter) {
            try {
                this.writer.write(out + "\n");
                this.writer.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace(Main.OUT);
            }
        }
    }

    @Override
    public void serve() {
    }

    @Override
    public void listen(Consumer<String> line_consumer) {
        this.ping();
        new Thread(() -> {
            while (true) {
                boolean one_line;
                String line;
                block12: {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(Main.OUT);
                    }
                    line = null;
                    try {
                        line = this.reader.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace(Main.OUT);
                        if (!this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown()) break block12;
                        this.kill("Socket connection lost");
                    }
                }
                boolean bl = one_line = line != null;
                while (line != null) {
                    if (line.startsWith("[PIN]")) {
                        this.ping();
                    } else if (line.startsWith("[KIL]")) {
                        this.kill("Minetest server shutting down; shutting down as well.");
                    } else {
                        line_consumer.accept(line);
                    }
                    try {
                        line = this.reader.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace(Main.OUT);
                    }
                }
                if (System.currentTimeMillis() - this.last_ping <= Main.PING_WAIT) continue;
                this.kill("No ping during the last " + Main.PING_WAIT / 1000L + "s; shutting down.");
            }
        }).start();
    }
}

