---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by lars.
--- DateTime: 12.03.19 16:26
---

timers={}

log.create_channel("hud_timers") -- Create log channel

local config=conf.import("hud_timers",{
    type="table",
    children={
        hud_timers_max={
            type="number",
            range={0, 100}
        },
        hud_pos= {
            type = "table",
            children = {
                x={type="number"},
                y={type="number"}
            }
        },
        globalstep={
            type = "number",
            range={0}
        },
        format={
            type="string"
        }
    }
})

table_ext.add_all(getfenv(1), config)

minetest.register_on_joinplayer(function(player)
    timers[player:get_player_name()]={}
end)

minetest.register_on_leaveplayer(function(player)
    timers[player:get_player_name()]={}
end)

local timer=0

minetest.register_globalstep(function(dtime)
    timer = timer + dtime;
    if timer >= globalstep then
        for playername, timers in pairs(timers) do
            maintain_timers(timers, timer, minetest.get_player_by_name(playername))
        end
        timer=0
    end
end)

function trigger_event(playername, event_name)
    for _, timer in ipairs(timers[playername]) do
        if timer.on_event and timer.on_event[event_name] then
            timer.on_event[event_name](playername, timer)
        end
    end
end

function add_timer(playername, timer_definition)
    local player=minetest.get_player_by_name(playername)
    local offset=0
    offset=#(timers[playername])
    if (offset==hud_timers_max) then
        return false
    end
    offset=offset*-20
    local bg_id=player:hud_add({
        hud_elem_type = "statbar",
        position = hud_pos,
        size = "",
        text = "hudbars_bar_background.png",
        number = 2,
        alignment = {x=1,y=1},
        offset = {x=0, y=offset},
    })
    local bar_id = player:hud_add({
        hud_elem_type = "statbar",
        position = hud_pos,
        size = "",
        text = "hud_timers_bar_timeout.png^[colorize:#"..(timer_definition.color or "000000"),
        number = 160,
        alignment = {x=1,y=1},
        offset = {x=1, y=offset+1},
    })
    local text_id = player:hud_add({
        hud_elem_type = "text",
        position = hud_pos,
        size = "",
        text = string.format(format, timer_definition.name, number_ext.round(timer_definition.duration,timer_definition.rounding_steps)),
        number = 0xFFFFFF,
        alignment = {x=1,y=1},
        offset = {x=1, y=offset},
    })

    log.write("hud_timers","Timer "..timer_definition.name.." with duration of "..timer_definition.duration.." added to the HUD of player "..playername)

    table.insert(timers[playername], {
        name=timer_definition.name or "Unnamed Timer",
        time_left=timer_definition.duration,
        duration=timer_definition.duration,
        on_complete=timer_definition.on_complete,
        on_event=timer_definition.on_event,
        rounding_steps=timer_definition.rounding_steps or 10,
        ids={bg=bg_id, bar=bar_id, label=text_id},
        y_shift=0
    })
    return #timers[playername]
end

function remove_timer(playername, timer_index)
    timers[playername][timer_index].time_left=-1
    maintain_timers(timers[playername],0,minetest.get_player_by_name(playername))
end

--Updates hud

function maintain_timers(timers,dtime,player)
    local y_shift=0
    for i, timer in table_ext.rpairs(timers) do
        local time_left=timer.time_left-dtime
        if (time_left <= 0) then
            player:hud_remove(timer.ids.bg)
            player:hud_remove(timer.ids.bar)
            player:hud_remove(timer.ids.label)
            y_shift=y_shift+20 -- Shift others downwards
            log.write("hud_timers","Timer "..timer.name.." with duration of "..timer.duration.." removed from the HUD of player "..player:get_player_name())
            table.remove(timers,i)
            if (timer.on_complete) then
                timer.on_complete(player:get_player_name(), timer)
            end
        else
            timers[i].time_left=time_left
            player:hud_change(timer.ids.label,"text",string.format(format, timer.name, number_ext.round(time_left,timer.rounding_steps)))
            player:hud_change(timer.ids.bar,"number",time_left/timer.duration*160)
            if not (y_shift == 0) then
                local offset_shifted={x=0,y=y_shift+timer.y_shift}
                offset_shifted.y=i*20
                timers[i].y_shift=y_shift+timer.y_shift
                player:hud_change(timer.ids.bg,"offset",offset_shifted)
                player:hud_change(timer.ids.bar,"offset",offset_shifted)
                player:hud_change(timer.ids.label,"offset",{x=offset_shifted.x+1,y=offset_shifted.y-1})
            end
        end
    end
end