---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by lars.
--- DateTime: 14.03.19 20:01
---

event_handlers={}

modlib.player.add_playerdata_function(function(playerdata)
    playerdata.last_placed=minetest.get_us_time()
end)
modlib.player.set_property_default("required_cooldown", 0)

modlib.log.create_channel("place_limit")

local config=modlib.conf.import("place_limit",{
    type="table",
    children={
        cooldown={
            type="table",
            children={
                default={
                    type="number",
                    range={0}
                },
                by_name= {
                    type = "table",
                    keys = { type = "string" },
                    values = { type = "number", range = { 0 } }
                },
                by_group= {
                    type = "table",
                    keys = { type = "string" },
                    values = { type = "number", range = { 0 } }
                }
            }
        }
    }
})

modlib.table.add_all(getfenv(1), config)

get_cooldown_by_name=function(nodename)
    return cooldown.by_name[nodename]
end

get_cooldown_by_group=function(groupname)
    return cooldown.by_group[groupname]
end

get_max_cooldown=function(nodename)
    local cooldowns={}
    cooldowns[1]=get_cooldown_by_name(nodename)
    local groups=minetest.registered_nodes[nodename].groups
    for groupname, groupvalue in pairs(groups) do
        local group_cooldown=get_cooldown_by_group(groupname)
        if group_cooldown then
            table.insert(cooldowns, groupvalue*group_cooldown)
        end
    end
    if modlib.table.is_empty(cooldowns) then
        return cooldown.default
    end
    return modlib.table.max(cooldowns)
end

register_on_placenode=function(callback)
    if type(callback) ~= "function" then
        modlib.log.write("place_limit", "Warning : register_on_placenode called with a non-function. Ignoring.")
        return
    end
    table.insert(event_handlers, callback)
    return #table
end

unregister_on_placenode=function(index)
    if event_handlers[index] then
        event_handlers[index]=nil
        return true
    end
    modlib.log.write("place_limit", "Warning : unregister_on_placenode called with an invalid index. Ignoring.")
    return false
end

minetest.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack, pointed_thing)
    if ((minetest.get_us_time()-modlib.player.get_property(placer:get_player_name(), "last_placed"))/1000000) < modlib.player.get_property(placer:get_player_name(), "required_cooldown") then
        minetest.swap_node(pos, oldnode)
        return true
    end
    modlib.player.set_property(placer:get_player_name(), "last_placed", minetest.get_us_time())
    local required_cooldown_for_player=get_max_cooldown(newnode.name)
    modlib.player.set_property(placer:get_player_name(), "required_cooldown",required_cooldown_for_player)
    hud_timers.add_timer(placer:get_player_name(), {name="Place Limit", duration=required_cooldown_for_player})
    for _, handler in pairs(event_handlers) do
        handler(pos, newnode, placer, oldnode, itemstack, pointed_thing)
    end
end)