minetest.register_node("brpg:black_rose", {
    description = "Black Rose",
    drawtype = "plantlike",
    tiles = {"brpg_black_rose.png"},
    inventory_image = "brpg_black_rose.png",
    wield_image = "brpg_black_rose.png",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    diggable = true,
    buildable_to = true,
    groups = {snappy=3, flammable=2, flora=1, attached_node=1, plant=2},
    selection_box = {
        type = "fixed",
        fixed = {-0.1, -0.5, -0.1, 0.1, 0.2, 0.1},
    },

    on_use = function(itemstack, user, pointed_thing)
        if itemstack:is_empty() then
            return itemstack
        end

        user:set_hp(0)  -- Убиваем игрока
        local pos = user:get_pos()  -- Получаем позицию игрока
        pos.y = pos.y + 1  -- Добавляем 1 к координате Y
        minetest.add_entity(pos, "brpg:ghost") -- Создаем призрака

        itemstack:take_item() 

        return itemstack
    end
})
