minetest.register_tool("brpg:metal_pickaxe", {
	description = ("Metal Pickaxe"),
	inventory_image = "brpg_metal_pickaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			cracky = {times={[1]=3.50, [2]=1.40, [3]=0.70}, uses=45, maxlevel=2},
		damage_groups = {fleshy=2},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1, flammable = 2}
  }
})

minetest.register_craft({
    output = "brpg:metal_pickaxe",
    recipe = {
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
        {"", "default:stick", ""},
        {"", "default:stick", ""},
    },
})

minetest.register_tool("brpg:metal_axe", {
	description = ("Metal Axe"),
	inventory_image = "brpg_metal_axe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=1.50, [2]=1.00, [3]=0.85}, uses=45, maxlevel=2},
		},
		damage_groups = {fleshy=4},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
 })

minetest.register_craft({
    output = "brpg:metal_axe",
    recipe = {
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
        {"brpg:metal_ignot", "default:stick", ""},
        {"", "default:stick", ""},
    },
})

minetest.register_tool("brpg:metal_shovel", {
	description = ("Metal Shovel"),
	inventory_image = "brpg_metal_shovel.png",
	wield_image = "brpg_metal_shovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=1.00, [2]=0.70, [3]=0.25}, uses=48, maxlevel=2},
		},
		damage_groups = {fleshy=3},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_craft({
    output = "brpg:metal_shovel",
    recipe = {
        {"", "brpg:metal_ignot", ""},
        {"", "default:stick", ""},
        {"", "default:stick", ""},
    },
})

minetest.register_tool("brpg:amethyst_pickaxe", {
	description = ("Amethyst Pickaxe"),
	inventory_image = "brpg_amethyst_pickaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			cracky = {times={[1]=2.25, [2]=1.00, [3]=0.45}, uses=68, maxlevel=2},
		damage_groups = {fleshy=2},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1, flammable = 2}
  }
})

minetest.register_craft({
    output = "brpg:amethyst_pickaxe",
    recipe = {
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
        {"", "brpg:metal_stick", ""},
        {"", "brpg:metal_stick", ""},
    },
})

minetest.register_tool("brpg:amethyst_axe", {
	description = ("Amethyst Axe"),
	inventory_image = "brpg_amethyst_axe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=1.25, [2]=0.75, [3]=0.65}, uses=68, maxlevel=2},
		},
		damage_groups = {fleshy=4.5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
 })

minetest.register_craft({
    output = "brpg:amethyst_axe",
    recipe = {
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
        {"brpg:mineral_amethyst", "brpg:metal_stick", ""},
        {"", "brpg:metal_stick", ""},
    },
})

minetest.register_tool("brpg:amethyst_shovel", {
	description = ("Amethyst Shovel"),
	inventory_image = "brpg_amethyst_shovel.png",
	wield_image = "brpg_amethyst_shovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=0.80, [2]=0.60, [3]=0.20}, uses=68, maxlevel=2},
		},
		damage_groups = {fleshy=3},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_craft({
    output = "brpg:amethyst_shovel",
    recipe = {
        {"", "brpg:mineral_amethyst", ""},
        {"", "brpg:metal_stick", ""},
        {"", "brpg:metal_stick", ""},
    },
})
