minetest.register_craftitem("brpg:mineral_amethyst", {
    description = "Amethyst",
    inventory_image = "brpg_amethyst.png",
})

minetest.register_craftitem("brpg:metal_ignot", {
    description = "Metal Ignot",
    inventory_image = "brpg_metal_ignot.png",
})

minetest.register_craft({
    output = "brpg:metal_ignot",
    recipe = {
        {"", "", ""},
        {"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
        {"", "", ""},
    },
})

minetest.register_craftitem("brpg:metal_stick", {
    description = "Metal Stick",
    inventory_image = "brpg_metal_stick.png",
})

minetest.register_craft({
    output = "brpg:metal_stick",
    recipe = {
        {"", "", ""},
        {"", "brpg:metal_ignot", ""},
        {"", "brpg:metal_ignot", ""},
    },
})

minetest.register_craftitem("brpg:potion_health", {
    description = "Potion Health",
    inventory_image = "brpg_potion_health.png",
    on_use = function(itemstack, user, pointed_thing)
        local hp_change = 15  
        local player_name = user:get_player_name()
        local hp = user:get_hp()
        if hp < 20 then
            user:set_hp(math.min(hp + hp_change, 20)) 
            if not minetest.setting_getbool("creative_mode") then
                itemstack:take_item() 
            end
            minetest.sound_play("", {pos=user:get_pos(), max_hear_distance = 10, gain = 1.0})
            return itemstack
        end
    end,
})

minetest.register_craft({
    output = "brpg:potion_health",
    recipe = {
        {"", "", ""},
        {"", "flowers:mushroom_red", ""},
        {"", "vessels:glass_bottle", ""},
    },
})
