local modpath = minetest.get_modpath("brpg")

minetest.register_entity("brpg:ghost", {
  name = "Ghost",
  description = "A friendly ghost.",
  hp_max = 30,
  physical = true,
  falling = true,
  walking = true,
  flight = true,
  move_type = "ground_nodes",
  collisionbox = {-0.3, -1.0, -0.3, 0.3, 1.0, 0.3},
  visual = "upright_sprite",
  visual_size = {x = 1, y = 2},
  textures = {"brpg_ghost.png"},
  walk_speed = 2,
  on_spawn = function(self)
    self.object:set_animation({
      "idle",
      "walk",
      "idle",
      "idle",
      "walk",
      "idle",
      "idle",
      "idle",
    })
  end,
  on_death = function(self)
    minetest.add_particle({
      pos = self.object:get_pos(),
      texture = "brpg_ghost_matter.png",
      size = 5.0,
      velocity = {x = 0, y = 0, z = 0},
      ttl = 1000,
    })
  end,
  on_attack = function(self, attacker)
    if attacker:is_player() then
      attacker:punch(self.object, 1, {full_punch_interval = 0.8})
    end
  end,

  on_step = function(self, dtime)
    local players = minetest.get_connected_players()
    if #players > 0 then

      local random_player = players[math.random(1, #players)]
      local player_pos = random_player:get_pos()
      local ghost_pos = self.object:get_pos()
      local distance = vector.distance(player_pos, ghost_pos)
      
 
      if distance < 10 then
        local direction = vector.direction(ghost_pos, player_pos)
        self.object:set_velocity(vector.multiply(direction, self.walk_speed))
      end
    end
  end
})