minetest.register_tool("brpg:metal_pickaxe", {
	description = ("Metal Pickaxe"),
	inventory_image = "brpg_metal_pickaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			cracky = {times={[1]=3.65, [2]=1.54, [3]=0.68}, uses=46, maxlevel=2},
		damage_groups = {fleshy=2},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1, flammable = 2}
  }
})

minetest.register_craft({
    output = "brpg:metal_pickaxe",
    recipe = {
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
        {"", "default:stick", ""},
        {"", "default:stick", ""},
    },
})

minetest.register_tool("brpg:metal_axe", {
	description = ("Metal Axe"),
	inventory_image = "brpg_metal_axe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.25, [2]=1.15, [3]=0.90}, uses=46, maxlevel=2},
		},
		damage_groups = {fleshy=4},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
 })

minetest.register_craft({
    output = "brpg:metal_axe",
    recipe = {
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
        {"brpg:metal_ignot", "default:stick", ""},
        {"", "default:stick", ""},
    },
})

minetest.register_tool("brpg:metal_shovel", {
	description = ("Metal Shovel"),
	inventory_image = "brpg_metal_shovel.png",
	wield_image = "brpg_metal_shovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=1.42, [2]=0.80, [3]=0.34}, uses=45, maxlevel=2},
		},
		damage_groups = {fleshy=3},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_craft({
    output = "brpg:metal_shovel",
    recipe = {
        {"", "brpg:metal_ignot", ""},
        {"", "default:stick", ""},
        {"", "default:stick", ""},
    },
})

minetest.register_tool("brpg:amethyst_pickaxe", {
	description = ("Amethyst Pickaxe"),
	inventory_image = "brpg_amethyst_pickaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			cracky = {times={[1]=1.6, [2]=0.7, [3]=0.35}, uses=58, maxlevel=2},
		damage_groups = {fleshy=2},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1, flammable = 2}
  }
})

minetest.register_craft({
    output = "brpg:amethyst_pickaxe",
    recipe = {
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
        {"", "brpg:metal_stick", ""},
        {"", "brpg:metal_stick", ""},
    },
})

minetest.register_tool("brpg:amethyst_axe", {
	description = ("Amethyst Axe"),
	inventory_image = "brpg_amethyst_axe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=1.85, [2]=0.80, [3]=0.38}, uses=58, maxlevel=2},
		},
		damage_groups = {fleshy=4.5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
 })

minetest.register_craft({
    output = "brpg:amethyst_axe",
    recipe = {
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
        {"brpg:mineral_amethyst", "brpg:metal_stick", ""},
        {"", "brpg:metal_stick", ""},
    },
})

minetest.register_tool("brpg:amethyst_shovel", {
	description = ("Amethyst Shovel"),
	inventory_image = "brpg_amethyst_shovel.png",
	wield_image = "brpg_amethyst_shovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=0.92, [2]=0.42, [3]=0.23}, uses=57, maxlevel=2},
		},
		damage_groups = {fleshy=3},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_craft({
    output = "brpg:amethyst_shovel",
    recipe = {
        {"", "brpg:mineral_amethyst", ""},
        {"", "brpg:metal_stick", ""},
        {"", "brpg:metal_stick", ""},
    },
})

minetest.register_craftitem("brpg:staff_water", {
  description = "Staff Water",
  inventory_image = "brpg_staff_water.png",
  on_use = function(itemstack, player, pointed_thing)
    if pointed_thing.type == "node" then
      local pos = pointed_thing.above 
      minetest.set_node(pos, {name = "default:water_source"}) 
    end
    return itemstack
  end,
})

minetest.register_craft({
    output = "brpg:staff_water",
    recipe = {
        {"", "", "brpg:sphere_water"},
        {"", "default:stick", ""},
        {"default:stick", "", ""},
    },
})

minetest.register_craftitem("brpg:staff_lava", {
  description = "Staff Lava",
  inventory_image = "brpg_staff_lava.png",
  on_use = function(itemstack, player, pointed_thing)
    if pointed_thing.type == "node" then
      local pos = pointed_thing.above 
      minetest.set_node(pos, {name = "default:lava_source"}) 
    end
    return itemstack
  end,
})

minetest.register_craft({
    output = "brpg:staff_lava",
    recipe = {
        {"", "", "brpg:sphere_lava"},
        {"", "default:stick", ""},
        {"default:stick", "", ""},
    },
})

minetest.register_craftitem("brpg:staff_teleport", {
  description = "Staff Teleportation ",
  inventory_image = "brpg_staff_teleport.png",
  on_use = function(itemstack, player, pointed_thing)
    if pointed_thing.type == "node" then
      local pos = pointed_thing.above 
      --  minetest.set_node(pos, {name = ""}) 
      player:setpos(pos) 
    end
    return itemstack
  end,
})

minetest.register_craft({
    output = "brpg:staff_teleport",
    recipe = {
        {"", "", "brpg:sphere_amethyst"},
        {"", "default:stick", ""},
        {"default:stick", "", ""},
    },
})
