minetest.register_node("brpg:black_rose", {
    description = "Black Rose",
    drawtype = "plantlike",
    tiles = {"brpg_black_rose.png"},
    inventory_image = "brpg_black_rose.png",
    wield_image = "brpg_black_rose.png",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    diggable = true,
    buildable_to = true,
    groups = {snappy=3, flammable=2, flora=1, attached_node=1, plant=2},
    selection_box = {
        type = "fixed",
        fixed = {-0.1, -0.5, -0.1, 0.1, 0.2, 0.1},
    },

    on_use = function(itemstack, user, pointed_thing)
        if itemstack:is_empty() then
            return itemstack
        end

        user:set_hp(0)
        local pos = user:get_pos()
        pos.y = pos.y + 1 
        minetest.add_entity(pos, "brpg:ghost") 

        itemstack:take_item() 

        return itemstack
    end
})

minetest.register_node("brpg:mythical_sprout", {
    description = "Mythical Sprout",
    drawtype = "plantlike",
    tiles = {"brpg_mythical_sprout.png"},
    inventory_image = "brpg_mythical_sprout.png",
    wield_image = "brpg_mythical_sprout.png",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    diggable = true,
    buildable_to = true,
    groups = {snappy=3, flammable=2, flora=1, attached_node=1},
    selection_box = {
        type = "fixed",
        fixed = {-0.1, -0.5, -0.1, 0.1, 0.2, 0.1},
    },
})

minetest.register_node("brpg:dark_sapling", {
  description = "Dark Sapling",
  drawtype = "plantlike",
  tiles = {"brpg_dark_sapling.png"},
  inventory_image = "brpg_dark_sapling.png",
  wield_image = "dark_sapling.png",
  paramtype = "light",
  sunlight_propagates = true,
  walkable = false,
  on_timer = grow_sapling,
  drop = "",
  selection_box = {
    type = "fixed",
    fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
  },
  groups = {snappy = 2, dig_immediate = 3, flammable = 3, attached_node = 1, sapling = 1, not_in_creative_inventory = 0},
  sounds = default.node_sound_leaves_defaults(),
})

function grow_sapling(pos, node)
 
  if node.name ~= "brpg:dark_sapling" then
    return
  end
  
  minetest.remove_node(pos)
  
  local schematic_path = minetest.get_modpath("brpg") .. "/schematics/dark_wood.mts"
  
  minetest.place_schematic(pos, schematic_path, "0", nil, true, "place_center_x, place_center_z")
end

minetest.register_abm({
  label = "Dark Sapling Growing",
  nodenames = {"brpg:dark_sapling"},
  interval = 1, -- 1 минута в тиках
  chance = 100, -- всегда срабатывает
  catch_up = false,
  action = grow_sapling,
})
