minetest.register_craftitem("brpg:mineral_amethyst", {
    description = "Amethyst",
    inventory_image = "brpg_amethyst.png",
})

minetest.register_craftitem("brpg:metal_ignot", {
    description = "Metal Ignot",
    inventory_image = "brpg_metal_ignot.png",
})

minetest.register_craft({
    output = "brpg:metal_ignot",
    recipe = {
        {"", "", ""},
        {"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
        {"", "", ""},
    },
})

minetest.register_craftitem("brpg:metal_stick", {
    description = "Metal Stick",
    inventory_image = "brpg_metal_stick.png",
})

minetest.register_craft({
    output = "brpg:metal_stick",
    recipe = {
        {"", "", ""},
        {"", "brpg:metal_ignot", ""},
        {"", "brpg:metal_ignot", ""},
    },
})

minetest.register_craftitem("brpg:watch", {
  description = "Часы",
  inventory_image = "brpg_watch.png",
  on_use = function(itemstack, player, pointed_thing)
    local time = os.date("%H:%M:%S")
    minetest.chat_send_player(player:get_player_name(), "Текущее время: " .. time)
    return itemstack
  end,
})

minetest.register_craftitem("brpg:watch", {
  description = "Watch",
  inventory_image = "brpg_watch.png", 
  on_use = function(itemstack, player, pointed_thing)
    local game_time = minetest.get_gametime()
    local hours = math.floor(game_time / 2400)
    local minutes = math.floor((game_time % 2400) / 40)
    local seconds = math.floor((game_time % 2400) % 40)
    local game_time_string = string.format("%02d:%02d:%02d", hours, minutes, seconds)

    local real_time = os.date("%H:%M:%S")

    minetest.chat_send_player(player:get_player_name(), "Игровое время: " .. game_time_string .. ", Реальное время: " .. real_time)
    return itemstack
  end,
})

minetest.register_craftitem("brpg:compass", {
  description = "Compass",
  inventory_image = "brpg_compass.png",
  on_use = function(itemstack, player, pointed_thing)
    local pos = player:get_pos()
    local x = pos.x
    local y = pos.y
    local z = pos.z
    minetest.chat_send_player(player:get_player_name(), "Координаты: X=" .. x .. ", Y=" .. y .. ", Z=" .. z)
    return itemstack
  end,
})

minetest.register_craftitem("brpg:essence_magic", {
    description = "Essence Magic",
    inventory_image = "brpg_essence_magic.png",
    on_use = function(itemstack, player, pointed_thing)
        minetest.sound_play("magic", {
            pos = player:getpos(),
            gain = 1.0,
            max_hear_distance = 16,
        })

    end,
})

minetest.register_craft({
    output = "brpg:essence_magic 9",
    recipe = {
        {"", "", ""},
        {"", "brpg:magic_block", ""},
        {"", "", ""},
    },
})

minetest.register_craftitem("brpg:sphere_water", {
    description = "Sphere Water",
    inventory_image = "brpg_sphere_water.png",
})

minetest.register_craft({
    output = "brpg:sphere_water",
    recipe = {
        {"", "brpg:essence_magic", ""},
        {"brpg:essence_magic", "bucket:bucket_water", "brpg:essence_magic"},
        {"", "brpg:essence_magic", ""},
    },
})

minetest.register_craftitem("brpg:sphere_lava", {
    description = "Sphere Lava",
    inventory_image = "brpg_sphere_lava.png",
})

minetest.register_craft({
    output = "brpg:sphere_lava",
    recipe = {
        {"", "brpg:essence_magic", ""},
        {"brpg:essence_magic", "bucket:bucket_lava", "brpg:essence_magic"},
        {"", "brpg:essence_magic", ""},
    },
})

minetest.register_craftitem("brpg:sphere_amethyst", {
    description = "Sphere Amethyst",
    inventory_image = "brpg_sphere_amethyst.png",
})

minetest.register_craft({
    output = "brpg:sphere_amethyst",
    recipe = {
        {"", "brpg:essence_magic", ""},
        {"brpg:essence_magic", "brpg:mineral_amethyst", "brpg:essence_magic"},
        {"", "brpg:essence_magic", ""},
    },
})

minetest.register_craftitem("brpg:old_sheet", {
    description = "Старый лист",
    inventory_image = "brpg_old_sheet.png",
    stack_max = 1,
    on_use = function(itemstack, user, pointed_thing)
        if pointed_thing then
            minetest.chat_send_player(user:get_player_name(), "Your task is to survive and develop, become the strongest. Some items can be obtained by breaking blocks, new ores in the bowels of the earth.")
        end
        itemstack:take_item()
        return itemstack
    end
})

minetest.register_on_newplayer(function(player)
	local inv = player:get_inventory()
	inv:add_item("main", "brpg:old_sheet")
end)