minetest.register_node("brpg:amethyst", {
	description = ("Mineral Amethyst"),
	tiles = {"default_stone.png^brpg_amethyst_mineral.png"},
	groups = {cracky = 1},
	drop = "brpg:mineral_amethyst",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_on_mods_loaded(function()
  minetest.register_ore({
    ore_type = "scatter",
    ore = "brpg:amethyst",
    wherein = "default:stone",
    clust_scarcity = 14 * 14 * 14,
    clust_num_ores = 4,
    clust_size = 5,
    y_min = -31000,
    y_max = -528,
  })
end)

minetest.register_node("brpg:magic_ore", {
	description = ("Magic Ore"),
	tiles = {"default_stone.png^brpg_magic_ore.png"},
	groups = {cracky = 1},
	drop = "brpg:essence_magic",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_on_mods_loaded(function()
  minetest.register_ore({
    ore_type = "scatter",
    ore = "brpg:magic_ore",
    wherein = "default:stone",
    clust_scarcity = 16 * 16 * 16,
    clust_num_ores = 3,
    clust_size = 4,
    y_min = -31000,
    y_max = -536,
  })
end)

minetest.register_decoration({
		name = "brpg:old_post",
		deco_type = "schematic",
		place_on = {"default:dirt_with_grass"},
		sidelen = 8,
		noise_params = {
			offset = -0.00018,
			scale = 0.0029,
			spread = {x = 200, y = 200, z = 200},
			seed = 230,
			octaves = 4,
			persist = 0.6
		},
		biomes = {"deciduous_forest"},
		y_max = 31000,
		y_min = -1000,
		schematic = minetest.get_modpath("brpg") .. "/schematics/old_post.mts",
		flags = "place_center_x, place_center_z, force_placement, all_floors",
	place_offset_y = 1,
	rotation = "random",
})



