minetest.register_node("brpg:metal_block", {
	description = ("Metal Block"),
	tiles = {"brpg_metal_block.png"},
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
    output = "brpg:metal_block",
    recipe = {
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
        {"brpg:metal_ignot", "brpg:metal_ignot", "brpg:metal_ignot"},
    },
})

minetest.register_node("brpg:amethyst_block", {
	description = ("Amethyst Block"),
	tiles = {"brpg_amethyst_block.png"},
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
    output = "brpg:amethyst_block",
    recipe = {
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
        {"brpg:mineral_amethyst", "brpg:mineral_amethyst", "brpg:mineral_amethyst"},
    },
})

minetest.register_node("brpg:magic_block", {
	description = ("Magic Block"),
	tiles = {"brpg_magic_block.png"},
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
    output = "brpg:magic_block",
    recipe = {
        {"brpg:essence_magic", "brpg:essence_magic", "brpg:essence_magic"},
        {"brpg:essence_magic", "brpg:essence_magic", "brpg:essence_magic"},
        {"brpg:essence_magic", "brpg:essence_magic", "brpg:essence_magic"},
    },
})

minetest.register_node("brpg:mystical_dirt", {
	description = ("Mystical Dirt"),
	tiles = {"brpg_mystical_dirt.png"},
	groups = {crumbly = 3, soil = 1},
	sounds = default.node_sound_dirt_defaults(),
})

minetest.register_node("brpg:mystical_with_grass", {
	description = ("Mystical with Grass"),
	tiles = {"brpg_mystical_grass.png", "brpg_mystical_dirt.png",
		{name = "brpg_mystical_dirt.png^brpg_mystical_grass_side.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, soil = 1, spreading_dirt_type = 1},
	drop = "brpg:mystical_dirt",
	sounds = default.node_sound_dirt_defaults({
		footstep = {name = "default_grass_footstep", gain = 0.25},
	}),
})

minetest.register_node("brpg:dark_wood", {
	description = ("Dark Wood Planks"),
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"brpg_dark_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_craft({
    output = "brpg:dark_wood 4",
    recipe = {
        {"", "", ""},
        {"", "brpg:dark_tree", ""},
        {"", "", ""},
    },
})

minetest.register_node("brpg:dark_tree", {
	description = ("Dark Tree"),
	tiles = {"brpg_tree_dark_top.png", "brpg_tree_dark_top.png", "brpg_tree_dark.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("brpg:leaves_dark", {
	description = ("Dark Tree Leaves"),
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"brpg_leaves_dark.png"},
	special_tiles = {"brpg_leaves_dark.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{
				-- player will get sapling with 1/20 chance
				items = {"brpg:dark_sapling"},
				rarity = 20,
			},
			{
				-- player will get leaves only if he get no saplings,
				-- this is because max_items is 1
				items = {"brpg:leaves_dark"},
			}
		}
	},
	sounds = default.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})

