minetest.register_node("brpg:potion_health", {
    description = "Potion Health",
    drop = "brpg:potion_health",
    drawtype = "plantlike",
    tiles = {"brpg_potion_health.png"},
    inventory_image = "brpg_potion_health.png",
    wield_image = "brpg_potion_health.png",
    is_ground_content = false,
    	walkable = false,
    paramtype = "light",
	   selection_box = {
	   	type = "fixed",
		  fixed = {-0.25, -0.5, -0.25, 0.25, 0.3, 0.25}
	},
    groups = {vessel = 1, dig_immediate = 3, attached_node = 1},
	sounds = default.node_sound_glass_defaults(),

    on_use = function(itemstack, user, pointed_thing)
        local hp_change = 18  
        local player_name = user:get_player_name()
        local hp = user:get_hp()
        if hp < 20 then
            user:set_hp(math.min(hp + hp_change, 20)) 
            if not minetest.setting_getbool("creative_mode") then
                itemstack:take_item() 
            end
            minetest.sound_play("", {pos=user:get_pos(), max_hear_distance = 10, gain = 1.0})
            return itemstack
        end
    end,
})

minetest.register_craft({
    output = "brpg:potion_health",
    recipe = {
        {"", "", ""},
        {"flowers:mushroom_red", "flowers:mushroom_red", "flowers:mushroom_red"},
        {"", "vessels:glass_bottle", ""},
    },
})

minetest.register_node("brpg:compote_blueberries", {
    description = "Blueberry compote",
    drop = "brpg:compote_blueberries",
    drawtype = "plantlike",
    tiles = {"brpg_compote_blueberries.png"},
    inventory_image = "brpg_compote_blueberries.png",
    wield_image = "brpg_compote_blueberries.png",
    is_ground_content = false,
    	walkable = false,
    paramtype = "light",
	   selection_box = {
	   	type = "fixed",
		  fixed = {-0.25, -0.5, -0.25, 0.25, 0.3, 0.25}
	},
    groups = {vessel = 1, dig_immediate = 3, attached_node = 1},
	sounds = default.node_sound_glass_defaults(),

    on_use = function(itemstack, user, pointed_thing)
        local hp_change = 8  
        local player_name = user:get_player_name()
        local hp = user:get_hp()
        if hp < 20 then
            user:set_hp(math.min(hp + hp_change, 20)) 
            if not minetest.setting_getbool("creative_mode") then
                itemstack:take_item() 
            end
            minetest.sound_play("", {pos=user:get_pos(), max_hear_distance = 10, gain = 1.0})
            return itemstack
        end
    end,
})

minetest.register_craft({
    output = "brpg:compote_blueberries",
    recipe = {
        {"", "", ""},
        {"default:blueberries", "default:blueberries", "default:blueberries"},
        {"", "vessels:glass_bottle", ""},
    },
})