minetest.register_biome({
	name = "mysticalforest",
	node_top = "brpg:mystical_with_grass",
	depth_top = 1,
	node_filler = "brpg:mystical_dirt",
	depth_filler = 1,
	node_stone = "default:stone",
	node_riverbed = "default:sand",
	depth_riverbed = 2,
	node_dungeon = "default:stone",
	node_dungeon_stair = "default:block",
	y_max = 31000,
	y_min = 4,
	heat_point = 50,
	humidity_point = 50,
})

minetest.register_decoration({
		name = "brpg:dark_wood",
		deco_type = "schematic",
		place_on = {"brpg:mystical_with_grass"},
		sidelen = 16,
		noise_params = {
			offset = -0.00018,
			scale = 0.0190,
			spread = {x = 250, y = 250, z = 250},
			seed = 230,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"mysticalforest"},
		y_max = 31000,
		y_min = -1000,
		schematic = minetest.get_modpath("brpg") .. "/schematics/dark_wood.mts",
	flags = "place_center_x, place_center_z",
	place_offset_y = 0,
	rotation = "random",
})

minetest.register_decoration({
  name = "brpg:mythical_sprout", 
  deco_type = "simple", 
  place_on = {"brpg:mystical_with_grass"}, 
  sidelen = 30,
  noise_params = {
   offset = -0.0003,
   scale = 0.9999,
   spread = {x = 230, y = 230, z = 230},
   seed = 230,
   octaves = 4,
   persist = 0.6
  },
  biomes = {"mysticalforest"},
  y_max = 31000,
  y_min = -1000,
  decoration = "brpg:mythical_sprout", 
  flags = "place_center_x, place_center_z", 
})

minetest.register_decoration({
		name = "brpg:stalactite ",
		deco_type = "schematic",
		place_on = {"brpg:mystical_with_grass"},
		sidelen = 8,
		noise_params = {
			offset = -0.00018,
			scale = 0.0029,
			spread = {x = 200, y = 200, z = 200},
			seed = 230,
			octaves = 4,
			persist = 0.6
		},
		biomes = {"mysticalforest"},
		y_max = 31000,
		y_min = -1000,
		schematic = minetest.get_modpath("brpg") .. "/schematics/stalactite.mts",
		flags = "place_center_x, place_center_z, force_placement, all_floors",
	place_offset_y = 1,
	rotation = "random",
})



