minetest.register_craftitem("vape:vape", {
 description = "Vape",
 inventory_image = "vape.png",
 on_use = function(itemstack, player, pointed_thing)
  minetest.sound_play("vape", {
   position = player:getpos(),
   gain = 0.5,
  })
  player:set_hp(player:get_hp() - 1)

  local pos = player:getpos()
  pos.y = pos.y + 1

  local obj = minetest.add_entity(pos, "vape:smoke")

  obj:set_velocity({x = 0, y = 1, z = 0})
 end,
})

minetest.register_craft({
    output = "vape:vape",
    recipe = {
        {"", "vessels:glass_fragments", ""},
        {"", "dye:blue", ""},
        {"", "default:steel_ingot", ""},
    },
})

minetest.register_entity("vape:smoke", {
 visual = "sprite", 
 textures = {"smoke.png"},  
 collisionbox = {0, 0, 0, 0, 0, 0}, 
})