-- SEAWATER
minetest.register_node(":tides:seawater", {
	description = ("tides:seawater : still water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "default_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquid_viscosity = 1,
	liquid_move_physics = true,
	liquidtype = "source",
	liquid_range = 3,
	liquid_alternative_flowing = "tides:wave",
	liquid_alternative_source = "tides:seawater",
	liquid_renewable = true,
	floodable = false,
	post_effect_color = {a = 103, r = 30, g = 30, b = 90},
	groups = {water = 3, liquid = 3, cools_lava = 1},
	--sounds = default.node_sound_water_defaults(),
})

minetest.register_node(":tides:wave", {
	description = ("tides:wave"),
	drawtype = "flowingliquid",--"flowingliquid",
	waving = 3,
	tiles = {"default_water.png"},
	special_tiles = {
		{
			name = "default_water_flowing_animated.png^[colorize:#99f:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "default_water_flowing_animated.png^[colorize:#99f:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquid_viscosity = 1,
	liquid_move_physics = true,
	liquidtype = "flowing",
	liquid_alternative_flowing = "tides:wave",
	liquid_alternative_source = "tides:seawater",
	liquid_renewable = false,
	floodable = true,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3, not_in_creative_inventory = 0,
		cools_lava = 1},
	--sounds = default.node_sound_water_defaults(),
})

--SHOREWATER
minetest.register_node(":tides:shorewater", {
	description = ("tides:shorewater : makes tides go down"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "default_water_source_animated.png^[colorize:#fff:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png^[colorize:#fff:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquid_viscosity = 1,
	liquid_move_physics = true,
	liquidtype = "source",--"source",
	liquid_range = 0,
	liquid_alternative_flowing = "tides:wave_shorewater",
	liquid_alternative_source = "tides:shorewater",
	liquid_renewable = false,
	floodable = false,
	post_effect_color = {a = 103, r = 30, g = 30, b = 90},
	groups = {water = 3, liquid = 3, cools_lava = 1},
	--sounds = default.node_sound_water_defaults(),
})

-- OFFSHORE_WATER
minetest.register_node(":tides:offshore_water", {
	description = ("tides:offshore_water : make tides rise"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "default_water_source_animated.png^[colorize:#000:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png^[colorize:#000:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquid_viscosity = 1,
	liquid_move_physics = true,
	liquidtype = "source",
	liquid_range = 0,
	liquid_alternative_flowing = "tides:wave_offshorewater",
	liquid_alternative_source = "tides:offshore_water",
	liquid_renewable = false,
	floodable = false,
	post_effect_color = {a = 103, r = 30, g = 30, b = 90},
	groups = {water = 3, liquid = 3, cools_lava = 1},
	--sounds = default.node_sound_water_defaults(),
})



-- these nodes have no purpose other than allowing shorewater and offshorewater
-- to have liquidtype = "source" to avoid issue #12718 with liquidtype = "none"

minetest.register_node(":tides:wave_shorewater", {
	description = ("tides:wave_shorewater"),
	drawtype = "flowingliquid",--"flowingliquid",
	waving = 3,
	tiles = {"default_water.png"},
	special_tiles = {
		{
			name = "default_water_flowing_animated.png^[colorize:#99f:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "default_water_flowing_animated.png^[colorize:#99f:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquid_viscosity = 1,
	liquid_move_physics = true,
	liquidtype = "flowing",
	liquid_range = 0,
	liquid_alternative_flowing = "tides:wave_shorewater",
	liquid_alternative_source = "tides:shorewater",
	liquid_renewable = false,
	floodable = true,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3, not_in_creative_inventory = 0,
		cools_lava = 1},
	--sounds = default.node_sound_water_defaults(),
})

minetest.register_node(":tides:wave_offshorewater", {
	description = ("tides:wave_offshorewater"),
	drawtype = "flowingliquid",--"flowingliquid",
	waving = 3,
	tiles = {"default_water.png"},
	special_tiles = {
		{
			name = "default_water_flowing_animated.png^[colorize:#99f:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "default_water_flowing_animated.png^[colorize:#99f:100",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquid_viscosity = 1,
	liquid_move_physics = true,
	liquidtype = "flowing",
	liquid_range = 0,
	liquid_alternative_flowing = "tides:wave_offshorewater",
	liquid_alternative_source = "tides:offshore_water",
	liquid_renewable = false,
	floodable = true,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3, not_in_creative_inventory = 0,
		cools_lava = 1},
	--sounds = default.node_sound_water_defaults(),
})