
--Rounding towards zero: 1,2,3,4. Rounding away from zero: 5,6,7,8,9.
local function round(val)
	local sign=1
	if val<0 then
		sign=-1
		val=val*-1
	end
	local floor=math.floor(val)
	--The first part avoids rounding errors for integers.
	return sign*((val==floor and floor) or math.floor(val+0.5))
end

local data={}
local time=0
local we=minetest.get_modpath("worldedit")~=nil
minetest.register_globalstep(function(dt)
	local players=minetest.get_connected_players()
	time=time+dt
	if time>0.1 then
		time=0
		local name=""
		for _,player in ipairs(players) do
			name=player:get_player_name()
			if not data[name] then
				break
			end
			local keys=player:get_player_control()
			if keys.aux1 then
				local itemStack=player:get_wielded_item()
				local itemName=itemStack:get_name()
				local pos=vector.round(player:get_pos())
				local node=minetest.get_node(pos)
				if itemStack:get_count()>0 and minetest.registered_nodes[itemName] then
					if not minetest.registered_nodes[node.name].buildable_to then 
						break
					elseif not we or data[name].size==0 then
						minetest.set_node(pos,{name=itemName})
					else
						worldedit.set(vector.subtract(pos,data[name].size),vector.add(pos,
							data[name].size),itemName)
					end
				else
					if not node or node.name=="air" then
						break
					elseif not we or data[name].size==0 then
						minetest.remove_node(pos)
					else
						worldedit.set(vector.subtract(pos,data[name].size),vector.add(pos,
							data[name].size),"air")
					end
				end
			end
		end
	end
end)

local function toCursor(name)
	local player=minetest.get_player_by_name(name)
	data[name]={prop=player:get_properties(),size=0}
	player:set_properties({
		collisionbox={-0.11,-0.11,-0.11,0.11,0.11,0.11},
		eye_height=0.0,
		stepheight=0.5,
		textures={"cursor_player.png"},
		visual="sprite",
		visual_size={x=0.1,y=0.1,z=0.1}})
end
minetest.register_chatcommand("toCursor",{privs={fly=true,noclip=true},
	func=toCursor})

local function fromCursor(player)
	local name
	if type(player)=="string" then
		name=player
		player=minetest.get_player_by_name(player)
	else
		name=player:get_player_name()
	end
	if data[name] then
		player:set_properties(data[name].prop)
		data[name]=nil
	end
end
minetest.register_chatcommand("fromCursor",{privs={fly=true,noclip=true},
	func=fromCursor})

minetest.register_on_leaveplayer(fromCursor)

if we then
	cursor={}
	function cursor.decrease(itemstack, player)
		local name=player:get_player_name()
		if data[name] and data[name].size>0 then
			data[name].size=data[name].size-1
			itemstack:set_wear(65535 - 6553.4 * data[name].size)
			return itemstack
		end
	end

	function cursor.increase(itemstack, player)
		local name=player:get_player_name()
		if data[name] and data[name].size<10 then
			data[name].size=data[name].size+1
			itemstack:set_wear(65535 - 6553.4 * data[name].size)
			return itemstack
		end
	end

	local modpath=minetest.get_modpath("cursor").."/"
	dofile(modpath.."worldedit.lua")
end

