**_Industrial Mese_ – A quality of life mod for Minetest Game**

## Intention

In *Minetest Game* Mese is a very rare material coming in the form of crystals or blocks. Mese can be used for crafting fast and long-lasting tools and some other items. With additional mods Mese becomes more versatile. Various mods use it as ingredients for technical or magical items.

If you like the challenge of Mese being a rare and harder to get element, or if you use a game that adds a different mechanic for better tools or magic/technic then this mod might not be the right mod for you. But if you see Mese as “just another thing to use” then you could be interested in this mod.

*Industrial Mese* adds, well, industrial Mese. Created as described below it can be used just like regular Mese. The mod automatically adds alternative recipes for all recipes using Mese. Just replace the Mese items in recipes with the corresponding *Industrial Mese* items (see compatibility section for details).

## Functionality

Creating an industrial Mese crystal needs some steps of preparation and crafting the base materials. First You need to get a Mese crystal fragment. This can be done by either crafting them using a Mese crystal or by fighting Mese monsters when you have *Mobs Redo* installed.

![Step 1](screenshots/imese_step_1.png)

You also need a cutting agent to dilute the Mese powder. For this, loosed cobblestone is used. It can be crafted from regular cobblestone. Then you need to mix those two ingredients together to create diluted Mese powder. Then you need to add water to the diluted Mese powder.

![Step 2](screenshots/imese_step_2.png)

![Step 3](screenshots/imese_step_3.png)

![Step 4](screenshots/imese_step_4.png)

This wet diluted Mese powder can be molded into a crystal using a Mese crystal mold. The molded Crystal then needs to be cooked. 

![Step 5](screenshots/imese_step_5.png)

![Step 6](screenshots/imese_step_6.png)

![Step 7](screenshots/imese_step_7.png)

With the crystals you can now craft all things you can usually craft with regular Mese crystals, too. Some recipes only yield ~70 percent of the result due to the lower quality of the industrial Mese crystals.

When molding the crystals, the mold is being damaged. 4 broken molds in a 2x2 pattern can be crafted into one steel ingot.

## Compatibility

The mod was tested with and is intended for Mesecons, Pipeworks, and Technic as mods for *Minetest Game*.

It uses delayed registration of alternate recipes. That means that all mods are automatically supported by *Industrial Mese* without any further action (assumed that those mods do not use delayed registration of their items. In this case race conditions could occur).

During testing it was made sure that no loopholes for creation of unlimited Mese were present. If mods allow uncrafting of the default tools for example then regular Mese crystals are returned which can be used to create industrial Mese crystals.

### Optional Compatibility Items

Some mods might already use a specific recipe so *Industrial Mese* runs into some issues with this mods by using the same recipe. Because not all players use those mods for simplicity reasons there is no compatibility checks built-in into this mod but it is possible to define a compatibility item for the base recipes of *Industrial Mese*

    imese_compatibility_item_mese_crystal_mold = default:stick
    imese_compatibility_item_mese_powder = default:stone
    imese_compatibility_item_cutting_agent = default:dirt

In the above example adds different compatibility items for the three base recipes. The Mese crystal mold needs an additional stick, the Mese powder needs an additional stone and the cutting agent needs an additional dirt node. The compatibility items are placed as near to the top left crafting slot as possible.

The top left slot has to be a stick when crafting the Mese crystal mold, and the top center slot has to be dirt when crafting the cutting agent. For the Mese powder the position does not matter because the recipe is shapeless.

The configuration can either be done in `./worlds/WORLDNAME/imese.conf` or in the global configuration file that is used for the server.

## Known issues

### The recipes are not shown in the *Minetest Game* craftguide

iMese uses delayed registration of recipes in order to support all mods without having them as optional dependencies to keep the dependency footprint as small as possible. The MTG craftguide uses delayed parsing of all items to create its recipe database on startup and does not re-parse it after mod loading state.

This causes race conditions leading into recipes sometimes not being showed in the craftguide and currently there is no way to fix this or manually register the recipes afterwards.

The recipes are registered for crafting, though. So any recipes that use Mese items can be “translated” to use the respective industrial Mese items.

## Translations

Missing your language? Feel free to add it!

[![Translation status](https://translate.codeberg.org/widget/linuxdirks-luanti-mods/imese/287x66-grey.png)](https://translate.codeberg.org/projects/linuxdirks-luanti-mods/imese)

