local modpath = core.get_modpath('imese')..DIR_DELIM
local itempath = modpath..'items'..DIR_DELIM
local syspath = modpath..'system'..DIR_DELIM
local worldpath = core.get_worldpath()..DIR_DELIM


-- Prepare global table for functionality
imese = {
    translator = core.get_translator('imese'),
    world_config = Settings(worldpath..'imese.conf'),
    default_loglevel = 'verbose',
}


-- IDs to be used for the created Industrial Mese items
imese.id = {
    crystal_mold_broken = 'imese:mese_crystal_mold_broken',
    crystal_mold        = 'imese:mese_crystal_mold',
    crystal_powder      = 'imese:mese_crystal_powder',
    cutting_agent       = 'imese:cutting_agent',
    diluted_powder_dry  = 'imese:diluted_mese_powder_dry',
    diluted_powder_wet  = 'imese:diluted_mese_powder_wet',
    molded_crystal      = 'imese:molded_mese_crystal',
    industrial_crystal  = 'imese:industrial_mese_crystal',
    industrial_shard    = 'imese:industrial_mese_crystal_shard',
    industrial_block    = 'imese:industrial_mese_block'
}


-- Replacements table for recipe conversion
imese.replacements = {
    ['default:mese_crystal'] = imese.id.industrial_crystal,
    ['default:mese_crystal_fragment'] = imese.id.industrial_shard,
    ['default:mese'] = imese.id.industrial_block
}


-- Load Mod functionality
dofile(syspath..'helpers.lua')
dofile(syspath..'register_base.lua')
imese.log('Mod functionality loaded')


-- Load built-in support for additional items after all mods are loaded and
-- clean up the global namespace.
core.register_on_mods_loaded(function()
    imese.log('Register alternate recipes')
    dofile(syspath..'register_recipes.lua')
    imese.log('Mod loading completed')
    imese = nil
end)
