-- This code overrides the default ladders from “Minetest Game”. This only
-- looks good when the default textures are used – or when textures are used
-- that have the same shape as the default textures.
--
-- The code is taken from the “Minor Redefinitions” mod. If you’re only
-- interested in making the default ladders 3D, you might want to use this
-- mod instead.
--
-- Git: https://git.0x7be.net/dirk/redef
-- CDB: https://content.luanti.org/packages/Linuxdirk/redef/
-- Forums: https://forum.luanti.org/viewtopic.php?t=24297


-- Load when unconfigured or explicitly enabled and if game ID is `minetest`
if ladders_3d.option('override_default_ladders', true) ~= true then return end
if ladders_3d.game.id ~= 'minetest' then return end


-- Minetest Game’s default laders
local ladders = {
    {'ladder_wood',  'default_ladder_wood.png',  'default_wood.png'},
    {'ladder_steel', 'default_ladder_steel.png', 'default_steel_block.png'}
}


-- Iterate over the ladders and replace them with a custom nodebox
for l,def in pairs(ladders) do
    core.override_item('default:'..def[1], {
        tiles = { def[2], def[2], def[3], def[3], def[3], def[3] },
        use_texture_alpha = 'clip',
        drawtype = 'nodebox',
        paramtype = 'light',
        node_box = {
            type = 'fixed',
            fixed = {
                {-0.375,  -0.5, -0.5,    -0.25,  -0.375, 0.5},     -- strut_1
                {0.25,    -0.5, -0.5,    0.375,  -0.375, 0.5},     -- strut_2
                {-0.4375, -0.5, 0.3125,  0.4375, -0.375, 0.4375},  -- rung_1
                {-0.4375, -0.5, 0.0625,  0.4375, -0.375, 0.1875},  -- rung_2
                {-0.4375, -0.5, -0.1875, 0.4375, -0.375, -0.0625}, -- rung_3
                {-0.4375, -0.5, -0.4375, 0.4375, -0.375, -0.3125}  -- rung_4
            }
        },
        selection_box = {
            type = 'wallmounted',
            wall_top    = {-0.4375, 0.375, -0.5,    0.4375, 0.5,    0.5},
            wall_side   = {-0.5,    -0.5,  -0.4375, -0.375, 0.5,    0.4375},
            wall_bottom = {-0.4375, -0.5,  -0.5,    0.4375, -0.375, 0.5}
        }
    })
end
