-- Localize Luanti functions
local get_dir_list = core.get_dir_list
local get_modpath = core.get_modpath
local get_worldpath = core.get_worldpath
local is_yes = core.is_yes


-- Create custom log function
local log = function (lvl, str) core.log(lvl, '[Ladders 3D] '..str) end


-- Set mod-related things
local modname = core.get_current_modname()
local modpath = get_modpath(modname)
local syspath = modpath..DIR_DELIM..'system'..DIR_DELIM
local regpath = modpath..DIR_DELIM..'registry'..DIR_DELIM


-- Initiante global table
ladders_3d = {
    game = core.get_game_info(),
    worldconfig = Settings(get_worldpath()..DIR_DELIM..'_ladders_3d.conf'),
    translator = core.get_translator(modname)
}


-- Load functions
dofile(syspath..'helpers.lua')
dofile(syspath..'register.lua')
log('info', 'Mod functionality fully loaded')


-- Run registration files for built-in mod support
--
-- Loading of built-in mod support can be configured either in the global
-- `mintest.conf` file or in a world-specific `_ladders_3d.conf` file. Settings
-- in the local file take precedence over global configuration.
--
--     # Disable loading built-in support for the mod named `modname`
--     ladders_3d_load_modname = false
--
-- If neither option is set, a sane built-in default value is used.
--
-- The registration files are named `modname.something.lua`. The `something`
-- part is optional and allows for separation of complex functionality for that
-- mod. The `modname` up to the first dot is used to determine the mod the
-- support file is for.
--
-- @see ladders_3d.option
for _,regfile in pairs(get_dir_list(regpath, false)) do
    local mod = regfile:gsub('%..*', '')
    local load = is_yes(ladders_3d.option('load_'..mod, true))
    local lua = regfile:gsub('.*%.', '') == 'lua'
    if (load == true) and (lua == true) and get_modpath(mod) then
        dofile(regpath..regfile)
        log('verbose', 'Loaded built-in mod support file `'..regfile..'`')
    end
    log('info', 'Built-in mod support processed')
end


-- APIfy mod
local register = ladders_3d.register
ladders_3d = { register = register }
