-- Get configuration options
local exact_selectionbox = ladders_3d.option('exact_selection_box', false)
local walkable_by_default = ladders_3d.option('walkable_by_default', false)


-- Default nodebox resembles the default “Minetest Game” ladder shape but in 3D.
local default_nodebox = {
    type = 'fixed',
    fixed = {
        { -6/16, -8/16, 6/16, -4/16,  8/16, 8/16 }, -- left
        {  4/16, -8/16, 6/16,  6/16,  8/16, 8/16 }, -- right
        { -7/16,  5/16, 6/16,  7/16,  7/16, 8/16 }, -- top
        { -7/16,  1/16, 6/16,  7/16,  3/16, 8/16 }, -- middle top
        { -7/16, -3/16, 6/16,  7/16, -1/16, 8/16 }, -- middle bottom
        { -7/16, -7/16, 6/16,  7/16, -5/16, 8/16 }, -- bottom
    }
}


-- Default selection box resembles the default “Minetest Game” ladder shape but
-- in 3D. When enabled, the selectionbox is based on the default nodebox.
local default_selectionbox = {
    type = 'fixed',
    fixed = { { -7/16, -8/16, 6/16, 7/16, 8/16, 8/16 } }
}

if exact_selectionbox == true then
    default_selectionbox = default_nodebox
end



-- Register a ladder
--
-- {
--   description = 'My Cool Ladder'
--   recipe = {},
--   yield = 7,
--   uncraft = '',
--   tiles = {},
--   sounds = {},
--   light = 0,
--   groups = {},
--   nodebox = {},
--   selectionbox = {},
--   walkable = false
-- }
ladders_3d.register = function (short_id, definition)
    local ladder_id = 'ladders_3d:'..short_id

    -- Set groups table
    local groups = { dig_immediate = 2 }
    for g,v in pairs(definition.groups or {}) do groups[g] = v end

    -- Register the node
    core.register_node(':'..ladder_id, {
        description = definition.description or ladder_id,
        tiles = definition.tiles,
        drawtype = 'nodebox',
        paramtype = 'light',
        node_box = definition.nodebox or default_nodebox,
        selection_box = definition.selectionbox or default_selectionbox,
        climbable = true,
        walkable = definition.walkable or walkable_by_default,
        sounds = definition.sounds,
        groups = groups,
        wield_image = definition.image,
        inventory_image = definition.image,
        paramtype2 = 'facedir',
        light_source = definition.light or 0,
    })

    -- Register recipe if available
    if definition.recipe then
        core.register_craft({
            output = ladder_id..' '..(definition.yield or 7),
            recipe = definition.recipe
        })
    end

    -- Register “uncrafting recipe” if available
    if definition.uncraft then
        core.register_craft({
            type = 'shapeless',
            output = definition.uncraft,
            recipe = { ladder_id }
        })
    end
end
