_**Ladders 3D** Is a mod that adds 3D ladders from a wide variety of base materials_

![All default ladders](screenshots/ladders_3d_default_ladders.jpg)

## Crafting

Crafting a ladder is done quite similar to crafting the default ladders. Instead of a stick the whole block is used. Just place in an `H` shape to get 7 ladders. To uncraft a ladder, just place it in the crafting grid to get one of the base block back.

![Crafting Recipe](screenshots/ladders_3d_craft.png)
![Uncrafting Recipe](screenshots/ladders_3d_uncraft.png)

The crafting recipe is more expensive than the de-facto standard recipe coming from “Minetest Game” `default` ladders. You get the materials back 1:1, though.

## Configuration options
Listed below are the configuration options that can be set either in the configuration that was used for the server or in the file `_ladders_3d.conf` in the world directory. Configuration options are set in the following order.

1. Built-in defaults
2. Configuration options
3. World-specific configuration options

A `settingtypes.txt` for the advanced configuration GUI for the Luanti client exists, but this does only set the global configuration options. It is suggested to use world-specific configuration options only, though.

```conf
# For each supported mod as `modname`. Refer to the Lua files in `registry` to
# get the currently supported mods.
ladders_3d_load_modname = true

# Override “Minetest Game” default ladders to look 3D (this is considered as a
# “hack” and only looks good with default textures for the ladders.)
ladders_3d_override_default_ladders = true

# Use exact selection box when no custom selection box is set. This does
# not apply to the overridden “Minetest Game” default ladders.
ladders_3d_exact_selection_box = false

# Players can walk through ladders. This sets the `walkable` node value. It is
# “reverse” of that the description is. If it is set to `false` players cannot
# walk through ladders.
ladders_3d_walkable_by_default = false
```

The listing above shows the default values. Please also refer to `settingtypes.txt` for a more in-detail description of the parameters. Individual registration files can introduce own configuration options. If the files are built-in the options should be noted in `settingtypes.txt`.

## Translations

Missing your language? Feel free to add it!

[![Translation status](https://translate.codeberg.org/widget/linuxdirks-luanti-mods/ladders_3d/287x66-grey.png)](https://translate.codeberg.org/projects/linuxdirks-luanti-mods/ladders_3d)

