-- Get a configuration value or return a default
--
-- This function takes an unprefixed value, automatically prefixes it and
-- tries to get the value from the global configuration or the world-specific
-- configuration. If the option is not found in any of those the given default
-- value is returned.
--
-- @param value   The unprefixed option to get
-- @param default The default value in case the option is not found
-- @return mixed  The value
ladders_3d.option = function (short_name, default)
    local option_name = 'ladders_3d_'..short_name
    local global_value = core.settings:get(option_name) or default
    local world_value = ladders_3d.worldconfig:get(option_name)
    return world_value or global_value
end
