-- Localize Luanti functions
local get_dir_list = core.get_dir_list
local get_modpath = core.get_modpath
local get_worldpath = core.get_worldpath
local is_yes = core.is_yes


-- Create custom log function
local log = function (lvl, str) core.log(lvl, '[Ladders 3D] '..str) end


-- Set mod-related things
local gamedef = core.get_game_info()
local modname = core.get_current_modname()
local modpath = get_modpath(modname)
local syspath = modpath..DIR_DELIM..'system'..DIR_DELIM
local regpath = modpath..DIR_DELIM..'registry'..DIR_DELIM


-- Initiante global table
ladders_3d = {
    game = gamedef,
    worldconfig = Settings(get_worldpath()..DIR_DELIM..'_ladders_3d.conf'),
    translator = core.get_translator(modname)
}


-- Load functions
dofile(syspath..'helpers.lua')
dofile(syspath..'register.lua')
log('info', 'Mod functionality fully loaded')


-- Run registration files for built-in mod support
for _,game in pairs(get_dir_list(regpath, true)) do
    if gamedef.id == game then
        log('info', 'Loading built-in mod support for `'..gamedef.title..'`')
        for _,file in pairs(get_dir_list(regpath..DIR_DELIM..game, false)) do
            local filepath = regpath..DIR_DELIM..game..DIR_DELIM..file
            local mod_id = file:gsub('%..*', '')
            local mod_variant = (file:gsub('%.lua', '')):gsub('.*%.', '')

            log('info', ('Loading support for "%m"%v'):gsub('%%%w+', {
                ['%m'] = mod_id,
                ['%v'] = mod_variant == mod_id
                    and ''
                    or ' ('..mod_variant:gsub('_', ' ')..')'
            }))

            dofile(filepath)
            log('verbose', 'Loaded '..filepath)
        end
    end
end


-- APIfy mod
log('verbose', 'Converting mod to API')
local register = ladders_3d.register
local mass_register = ladders_3d.mass_register
ladders_3d = { register = register, mass_register = mass_register }
