if not ladders_3d.option('mineclonia_register_metal_ladders', true) then
    return
end


local S = ladders_3d.translator
local register = ladders_3d.register


-- Normal, upright nodebox
local nodebox = {
    {-0.375, -0.5, 0.375, -0.25, 0.5, 0.5},       -- strut_l
    {0.25, -0.5, 0.375, 0.375, 0.5, 0.5},         -- strut_r
    {-0.4375, 0.25, 0.375, 0.4375, 0.375, 0.5},   -- rung_top
    {-0.4375, -0.25, 0.375, 0.4375, -0.125, 0.5}, -- rung_bottom
    {-0.25, 0.125, 0.375, -0.1875, 0.25, 0.5},    -- holder_tl
    {0.1875, 0.125, 0.375, 0.25, 0.25, 0.5},      -- holder_tr
    {-0.25, -0.375, 0.375, -0.1875, -0.25, 0.5},  -- holder_bl
    {0.1875, -0.375, 0.375, 0.25, -0.25, 0.5},    -- holder_br
}


local mask = '(ladders_3d_mineclonia_screws_mask.png^[opacity:96)'
local gold = '(default_gold_block.png^[transformFX^'..mask..')'
local iron = '(default_steel_block.png^[transformR190^'..mask..')'


register('mcl_core_gold', {
    description = S('Golden Ladder'),
    tiles = { gold },
    image = '('..gold..'^[mask:ladders_3d_mineclonia_inventory_mask.png)',
    nodebox = nodebox,
    sounds = core.registered_nodes['mcl_core:goldblock'].sounds,
    nodebox = { type = 'fixed', fixed = nodebox },
    recipe = {
        { 'mcl_core:gold_ingot','',                   'mcl_core:gold_ingot' },
        { 'mcl_core:gold_ingot','mcl_core:gold_ingot','mcl_core:gold_ingot' },
        { 'mcl_core:gold_ingot','',                   'mcl_core:gold_ingot' }
    },
    uncraft = 'mcl_core:gold_ingot'
})


register('mcl_core_iron', {
    description = S('Iron Ladder'),
    tiles = { iron },
    image = '('..iron..'^[mask:ladders_3d_mineclonia_inventory_mask.png)',
    nodebox = nodebox,
    sounds = core.registered_nodes['mcl_core:ironblock'].sounds,
    nodebox = { type = 'fixed', fixed = nodebox },
    recipe = {
        { 'mcl_core:iron_ingot','',                   'mcl_core:iron_ingot' },
        { 'mcl_core:iron_ingot','mcl_core:iron_ingot','mcl_core:iron_ingot' },
        { 'mcl_core:iron_ingot','',                   'mcl_core:iron_ingot' }
    },
    uncraft = 'mcl_core:gold_ingot'
})
