if not ladders_3d.option('mineclonia_register_wooden_ladders', true) then
    return
end


local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register


-- Normal, upright nodebox
local nodebox = {
    {-0.375, -0.5, 0.375, -0.25, 0.5, 0.5},       -- strut_l
    {0.25, -0.5, 0.375, 0.375, 0.5, 0.5},         -- strut_r
    {-0.4375, 0.25, 0.375, 0.4375, 0.375, 0.5},   -- rung_top
    {-0.4375, -0.25, 0.375, 0.4375, -0.125, 0.5}, -- rung_bottom
    {-0.25, 0.125, 0.375, -0.1875, 0.25, 0.5},    -- holder_tl
    {0.1875, 0.125, 0.375, 0.25, 0.25, 0.5},      -- holder_tr
    {-0.25, -0.375, 0.375, -0.1875, -0.25, 0.5},  -- holder_bl
    {0.1875, -0.375, 0.375, 0.25, -0.25, 0.5},    -- holder_br
}


local m = 'ladders_3d_mineclonia_screws_mask.png'
local t=function (b, o) return b..'^('..m..'^[opacity:'..(o or 96)..')' end


mass_register({
    mcl_trees_wood_acacia =         { S('Acacia Wood Ladder'),          'mcl_trees:wood_acacia',         t('default_acacia_wood.png'),         32, nodebox },
    mcl_trees_wood_bamboo =         { S('Bamboo Ladder'),               'mcl_trees:wood_bamboo',         t('mcl_bamboo_bamboo_plank.png', 64), 32, nodebox },
    mcl_trees_wood_birch =          { S('Birch Wood Ladder'),           'mcl_trees:wood_birch',          t('mcl_core_planks_birch.png'),       32, nodebox },
    mcl_trees_wood_cherry_blossom = { S('Cherry Blossom Wood Ladder'),  'mcl_trees:wood_cherry_blossom', t('mcl_cherry_blossom_planks.png'),   32, nodebox },
    mcl_trees_wood_crimson =        { S('Crimson Wood Ladder'),         'mcl_trees:wood_crimson',        t('crimson_hyphae_wood.png'),         32, nodebox },
    mcl_trees_wood_dark_oak =       { S('Dark Oak Wood Ladder'),        'mcl_trees:wood_dark_oak',       t('mcl_core_planks_big_oak.png'),     32, nodebox },
    mcl_trees_wood_jungle =         { S('Jungle Wood Ladder'),          'mcl_trees:wood_jungle',         t('default_junglewood.png'),          32, nodebox },
    mcl_trees_wood_mangrove =       { S('Magrove Wood Ladder'),         'mcl_trees:wood_mangrove',       t('mcl_mangrove_planks.png'),         32, nodebox },
    mcl_trees_wood_oak =            { S('Oak Wood Ladder'),             'mcl_trees:wood_oak',            t('default_wood.png'),                32, nodebox },
    mcl_trees_wood_spruce =         { S('Spruce Wood Ladder'),          'mcl_trees:wood_spruce',         t('mcl_core_planks_spruce.png'),      32, nodebox },
    mcl_trees_wood_warped =         { S('Warped Wood Ladder'),          'mcl_trees:wood_warped',         t('warped_hyphae_wood.png'),          32, nodebox }
})
