-- vim:nowrap
--
-- This file contains wide tables to wrapping is disabled.


local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register
local option = ladders_3d.option


-- Wooden ladders from default wood nodes
if option('minetest_register_wooden_ladders', true) == true then
    mass_register({
        default_aspen_wood = {  S('Aspen Wood Ladder'),  'default:aspen_wood',  'default_aspen_wood.png^[transformR180',  32 },
        default_pine_wood = {   S('Pine Wood Ladder'),   'default:pine_wood',   'default_pine_wood.png^[transformR180',   32 },
        default_jungle_wood = { S('Jungle Wood Ladder'), 'default:junglewood',  'default_junglewood.png^[transformR180',  32 },
        default_acacia_wood = { S('Acacia Wood Ladder'), 'default:acacia_wood', 'default_acacia_wood.png^[transformR180', 32 },
    })
end


-- Metal ladders from default metal nodes
if option('minetest_register_metal_ladders', true) == true then
    mass_register({
        default_gold = {   S('Golden Ladder'), { 'default:gold_ingot', 'default:gold_block' },     'default_gold_block.png',   32 },
        default_tin = {    S('Tin Ladder'),    { 'default:tin_ingot', 'default:tin_block' },       'default_tin_block.png',    32 },
        default_bronze = { S('Bronze Ladder'), { 'default:bronze_ingot', 'default:bronze_block' }, 'default_bronze_block.png', 64 },
        default_copper = { S('Copper Ladder'), { 'default:copper_ingot', 'default:copper_block' }, 'default_copper_block.png', 32 },
    })
end
