_**Ladders 3D** Is a mod that adds 3D ladders from a wide variety of base materials_

![All default ladders](screenshots/ladders_3d_minetest_default_ladders.jpg)

## Crafting

Crafting a ladder is done quite similar to crafting the “Minetest Game” default ladders. Instead of a stick the whole block is used. Just place in an `H` shape to get 7 ladders. To uncraft a ladder, just place it in the crafting grid to get one of the base item back.

![Crafting Recipe](screenshots/ladders_3d_minetest_craft.png)
![Uncrafting Recipe](screenshots/ladders_3d_minetest_uncraft.png)

The crafting recipe is more expensive than the de-facto standard recipe coming from “Minetest Game” `default` ladders. You get the materials back 1:1, though.

For individual materials please refer to your game’s crafting guide.

## Currently supported games

Please note that the 3D effect heavily depends on th einterplay of textures, texture masks, and nodeboxes. The mod was tested with the default textures and ladder shapes of the games. If you use non-standard textures or shapes, the registered ladders might not look correct.

* [Mineclonia][mcl]
* [Minetest Game][mtg]
* [Repixture][rp]

Want to have your favorite game being supported? Have a look at [the registration API readme](registry/README.md) on how to do that by yourself or how to request support being added.

## Configuration options

Listed below are the configuration options that can be set either in the configuration that was used for the server or in the file `_ladders_3d.conf` in the world directory. Configuration options are set in the following order.

1. Built-in defaults
2. Configuration options
3. World-specific configuration options

A `settingtypes.txt` for the advanced configuration GUI for the Luanti client exists, but this does only set the global configuration options. It is suggested to use world-specific configuration options only, though.

```ini
# Mod configuration
ladders_3d_exact_selection_box = false
ladders_3d_walkable_by_default = false

# Built-in support for Minetest Game
ladders_3d_minetest_override_default_ladders = true
ladders_3d_minetest_register_wooden_ladders = true
ladders_3d_minetest_register_metal_ladders = true

# Built-in support for Mineclonia
ladders_3d_mineclonia_override_default_ladder = true
ladders_3d_mineclonia_register_wooden_ladders = true
ladders_3d_mineclonia_register_metal_ladders = true

# Built-in support for Repixture
ladders_3d_mineclonia_register_metal_ladders = true
ladders_3d_mineclonia_register_wooden_ladders = true
```

The listing above shows the default values. The names are pretty much self-explanatory. The options being quite similar is coincidental, and individual registration files can introduce own configuration options.

## Translations

Missing your language? Feel free to add it!

[![Translation status](https://translate.codeberg.org/widget/linuxdirks-luanti-mods/ladders_3d/287x66-grey.png)](https://translate.codeberg.org/projects/linuxdirks-luanti-mods/ladders_3d)

[mcl]: https://content.luanti.org/packages/ryvnf/mineclonia/
[mtg]: https://content.luanti.org/packages/Luanti/minetest_game/
[rp]: https://content.luanti.org/packages/Wuzzy/repixture/
