-- vim:nowrap
--
-- This file contains wide tables to wrapping is disabled.


local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register
local option = ladders_3d.option


-- Wooden ladders from default wood nodes
if option('minetest_register_wooden_ladders', true) == true then
    mass_register({
        groups = { dig_immediate = 2 },
        ladders = {
            default_aspen_wood = {  S('Aspen Wood Ladder'),  'default:aspen_wood',  'default_aspen_wood.png^[transformR180'  },
            default_pine_wood = {   S('Pine Wood Ladder'),   'default:pine_wood',   'default_pine_wood.png^[transformR180'   },
            default_jungle_wood = { S('Jungle Wood Ladder'), 'default:junglewood',  'default_junglewood.png^[transformR180'  },
            default_acacia_wood = { S('Acacia Wood Ladder'), 'default:acacia_wood', 'default_acacia_wood.png^[transformR180' }
        }
    })
end


-- Metal ladders from default metal nodes
if option('minetest_register_metal_ladders', true) == true then
    local sounds = core.registered_nodes['default:steelblock'].sounds
    mass_register({
        groups = { dig_immediate = 2 },
        sounds = sounds,
        ladders = {
            default_gold = {   S('Golden Ladder'), 'default:gold_ingot',   'default_gold_block.png'   },
            default_tin = {    S('Tin Ladder'),    'default:tin_ingot',    'default_tin_block.png'    },
            default_bronze = { S('Bronze Ladder'), 'default:bronze_ingot', 'default_bronze_block.png' },
            default_copper = { S('Copper Ladder'), 'default:copper_ingot', 'default_copper_block.png' }
        }
    })
end
