-- Get a boolean configuration value or return a default
--
-- This function takes an unprefixed value, automatically prefixes it
-- with `ladders_3d` and tries to get the boolean value from the global
-- configuration or the world-specific configuration.
--
-- If the option is not found in any of those – the given default value
-- is returned instead.
--
-- @param value   Unprefixed boolean option to get
-- @param default Default boolean value in case the option is not found
-- @return mixed  Boolean value as requested, or the default
ladders_3d.option = function (short_name, default)
    local option_name = 'ladders_3d_'..short_name
    local global_value = core.settings:get_bool(option_name, default)
    local world_value = ladders_3d.worldconfig:get_bool(option_name)
    return world_value or global_value
end
