-- Localize Luanti functions
local get_dir_list = core.get_dir_list
local get_modpath = core.get_modpath
local get_worldpath = core.get_worldpath
local is_yes = core.is_yes


-- Set mod-related things
local gamedef = core.get_game_info()
local modname = core.get_current_modname()
local modpath = get_modpath(modname)
local syspath = modpath..DIR_DELIM..'system'..DIR_DELIM
local regpath = modpath..DIR_DELIM..'registry'..DIR_DELIM


-- Initiante global table
ladders_3d = {
    game = gamedef,
    modname = modname,
    worldconfig = Settings(get_worldpath()..DIR_DELIM..'_ladders_3d.conf'),
    translator = core.get_translator(modname)
}


-- Load functions
dofile(syspath..'helpers.lua')
dofile(syspath..'register.lua')
local log = ladders_3d.log
log('info', 'Mod functionality fully loaded')


-- Run registration files for built-in mod support
for _,game in pairs(get_dir_list(regpath, true)) do
    if gamedef.id == game then
        regpath = regpath..game..DIR_DELIM
        for _,modfile in pairs(get_dir_list(regpath, false)) do
            local mod = modfile:gsub('%..*', '')
            local suffix = modfile:gsub('.*%.', '')
            local support = modfile:gsub('%.lua', ''):gsub(mod..'%.', '')
            local mod_loaded = core.get_modpath(mod)
            local valid = suffix == 'lua' and mod_loaded
            if ladders_3d.option(support, true) and valid then
                log('info', 'Loading '..game..DIR_DELIM..modfile)
                dofile(regpath..modfile)
            else
                log('verbose', 'Found '
                    ..game..DIR_DELIM..modfile
                    ..' but file was not loaded.')
            end
        end
    end
end


-- APIfy mod
ladders_3d.log('verbose', 'Converting mod to API')
local register = ladders_3d.register
local mass_register = ladders_3d.mass_register
ladders_3d = { register = register, mass_register = mass_register }
